﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" >

            <div data-options="region:'center',title:'لیست درخواست های مجوز تردد'">
                <table id="grdTrafficLicenseList">
                    <thead>
                        <tr>
                            <th field="ck" checkbox="true"></th>
                            <th data-options="field:'TrafficLicenseId', sortable:'true',width:25 ">ID</th>
                            <th data-options="field:'FinalRequestByFullName', sortable:'true',width:120">درخواست دهنده</th>
                            <th data-options="field:'RequestBy', sortable:'true',width:120">نام کاربری</th>
                            

                            <th data-options="field:'MISPlate', sortable:'true',width:100">پلاک </th>
                            <th data-options="field:'ProductTitle', sortable:'true',width:250">نوع مجوز </th>
                            <th data-options="field:'LicenseValidDateFrom', sortable:'true',width:80,type:'datebox'">اعتبار از</th>
                            <th data-options="field:'LicenseValidDateTo', sortable:'true',width:80,type:'datebox'">اعتبار تا</th>
                            <!--<th data-options="field:'WorkFlowActionTypeTitle', sortable:'true',width:80,formatter:WfState">عملیات قبل</th>-->
                            <th data-options="field:'LicensingStatuseTitle', sortable:'true',width:80">وضعیت درخواست</th>
                            <th data-options="field:'CargoTitle',type: 'datebox', sortable:'true',width:100">نوع فعالیت </th>
                            <!--<th data-options="field:'LicenseNumber', sortable:'true',width:100,type:'integer'">شماره پروانه </th>-->
                            <th data-options="field:'RequestDate', sortable:'true',width:80,type:'datebox'">تاریخ درخواست </th>
                            <th data-options="field:'LicenseDate', sortable:'true',width:100,type:'integer'">تاریخ صدور</th>
                            <th data-options="field:'IsPaid', sortable:'true', width:110,formatter:formatIsPaidView"> وضعیت پرداخت  </th>
                        </tr>
                    </thead>
                </table>

                
                <div id="gridtoolbar" style="padding:2px 5px;">
                    <a href="#" class="easyui-linkbutton" onclick="displayLicenseDetail()" iconcls="icon-display">نمایش اطلاعات درخواست </a>

                    <input tabindex="4" id="txtIranPlateNoCarList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                    <span>ایران</span>
                    <input tabindex="3" id="txtThreePlateNoCarList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                    <select tabindex="2" id="drpTwoPlateNoCarList" class="easyui-combobox" data-options="width:'70px'">
                        <option value="-1" selected="selected"></option>
                        <option value="01">الف</option>
                        <option value="02">ب</option>
                        <option value="04">ت</option>
                        <option value="06">ج</option>
                        <option value="07">چ-ژ</option>
                        <option value="10">د</option>
                        <option value="15">س</option>
                        <option value="17">ص</option>
                        <option value="19">ط</option>
                        <option value="21">ع</option>
                        <option value="24">ق</option>
                        <option value="27">ل</option>
                        <option value="28">م</option>
                        <option value="29">ن</option>
                        <option value="30">و</option>
                        <option value="31">هـ</option>
                        <option value="32">ی</option>
                        <option value="33">D</option>
                        <option value="34">S</option>

                    </select>

                    <input tabindex="1" type="text" id="txtOnePlateNoCarList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">
                    نوع مجوز :<select id="drpTrafficLicenseType" class="easyui-combobox" data-options="width:'350px',panelHeight:'auto',editable:false">
                    </select>
                    وضعیت درخواست :<select id="drpLicenseStatus" class="easyui-combobox" data-options="width:'150px',panelHeight:'auto',editable:false">
                    </select>
                    <!--نوع فعالیت :<select id="drpActivityType" class="easyui-combobox" data-options="width:'200px',panelHeight:'auto',editable:false">
        </select>-->
                    <a onclick="clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                    <a href="#" class="easyui-linkbutton" onclick="searchAll()" iconcls="">   جست و جو   </a>
                    <a id="btnPrintLic" onclick="PrintLic()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ مجوز</a>
                    <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
                </div>
            </div>
        </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>

    
        //restrictAccess();
        function toExcel() {
            $('#grdTrafficLicenseList').datagrid('toExcel', 'dg.xls');
    }


    function clearFilter() {

        $('#txtOnePlateNoCarList').textbox('clear');
        $('#txtThreePlateNoCarList').textbox('clear');
        $('#txtIranPlateNoCarList').textbox('clear');
        $('#drpTwoPlateNoCarList').combobox('reset');
        //$('#drpTwoPlateNo').combobox('unselect', value);

        //var opts = grdLicensingCarList.datagrid('options');
        //opts.isBindOnLoad = true;


        //opts.queryParams['plaqueValue'] = '';
        //opts.queryParams['type'] = 0;
        //grdLicensingCarList.datagrid('reload', opts.queryParams);

    }
    function WfState(rowIndex, rowData) {
        if (rowData.WorkFlowActionTypeId === 0) {
            return `<span style='color:red'> رد شده </span>`;
        }
        return rowData.WorkFlowActionTypeTitle
    }



        
        var grdTrafficLicenseList = $('#grdTrafficLicenseList');

        $(function () {

            $('#drpTrafficLicenseType').combobox({
                method: 'get',
                url: '/TrafficLicenses/API/TrafficLicense/TrafficLicenseKinds?withAll=true',
                valueField: 'ProductTypeId',
                textField: 'Title',
                multiple: false,
            });

            //$('#drpActivityType').combobox({
            //    method: 'get',
            //    url: '/CoreServices/API/Base/CompanyActivityTypes?withAll=true',
            //    valueField: 'CompanyActivityTypeId',
            //    textField: 'Title',
            //    multiple: false,
            //});

            $('#drpLicenseStatus').combobox({
                method: 'get',
                url: '/CoreServices/API/UsersAccess/AccessLicenseStatuses?subSystemId=4',
                valueField: 'LicenseStatusId',
                textField: 'LicenseStatusTitle',
                multiple: false,
            });

            //$('#drpActivityType').combobox('setValue', '0');
            $('#drpLicenseStatus').combobox('setValue', '0');

            grdTrafficLicenseList.datagrid({
                //title: '',
                view: detailview,
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: true,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 20,
                pageList: [5, 10, 20, 50, 100, 99999],
                url: '/TrafficLicenses/API/TrafficLicense/TrafficLicensesList',
                rownumbers: true,
                sortName: 'TrafficLicenseId',
                sortOrder: 'desc',
                toolbar: '#gridtoolbar',
                singleSelect: true,
                detailFormatter: function (index, row) {
                    return '<div style="padding:2px"><table class="ddv"></table></div>';
                },
                onExpandRow: function (index, row) {
                    var ddv = $(this).datagrid('getRowDetail', index).find('table.ddv');
                    ddv.datagrid({
                        url: '/TrafficLicenses/API/TrafficLicense/EventsByTrafficLicenseId?trafficLicenseId=' + row.TrafficLicenseId,
                        method: 'get',
                        fitColumns: true,
                        singleSelect: true,
                        rownumbers: true,
                        loadMsg: 'صبر کنید - درحال بارگذرای',
                        pagination: true,
                        pageSize: 10,
                        sortName: 'EventId',
                        height: 'auto',
                        columns: [[
                            { field: 'EventDate', title: 'تاریخ', width: 100 },
                            { field: 'FullName', title: 'کاربر', width: 120 },
                            { field: 'ActionTitle', title: 'عملیات', width: 120 },
                            { field: 'StatusFrom', title: 'وضعیت اولیه', width: 120 },
                            { field: 'StatusTo', title: 'وضعیت نهایی', width: 120 },
                            { field: 'ActionDescription', title: 'توضیحات', width: 300 }
                        ]],
                        onResize: function () {
                            grdTrafficLicenseList.datagrid('fixDetailRowHeight', index);
                        },
                        onLoadSuccess: function () {
                            setTimeout(function () {
                                grdTrafficLicenseList.datagrid('fixDetailRowHeight', index);
                            }, 0);
                        }
                    });
                    grdTrafficLicenseList.datagrid('fixDetailRowHeight', index);
                },
                queryParams: {
                    //licenseStatusId: 0,
                    //IsNewLicense: -1,
                    //activityTypeId:-1
                }
            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            grdTrafficLicenseList.datagrid('enableFilter', [
                
                {
                    field: 'FinalRequestByFullName',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'RequestBy',
                    type: 'text',
                    op: textOp,
                },
                //{
                //    field: 'CompanyName',
                //    type: 'text',
                //    op: textOp,
                //},
                //{
                //    field: 'RequestByUser',
                //    type: 'text',
                //    op: textOp,
                //}

            ]);

        });


        function displayLicenseDetail() {
            
            var state = 1;//نمایش اطلاعات
            var row = grdTrafficLicenseList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            
            window.open('/AdminBaraneh/TrafficLicense/TrafficLicenseRequestEdit.aspx?TrafficLicenseId=' + row.TrafficLicenseId );

        }

        function PrintLic() {
           
            var row = grdTrafficLicenseList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            window.open('/Reports/Print/PrintTrafficLicense.html?guid=' + row.TrafficLicenseGUID);

        }

        

        function searchAll() {

            var opts = grdTrafficLicenseList.datagrid('options');
            var licenseStatusId = $("#drpLicenseStatus").combobox("getValue");
            var productTypeId = $("#drpTrafficLicenseType").combobox("getValue");
            //var cargoTypeId = $("#drpActivityType").combobox("getValue");

            plateNo = getPlateNo(false, 'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plateNo !== 'error') {
                opts.queryParams['plateNo'] = plateNo;
            }
            else {
                opts.queryParams['plateNo'] = '';
            }
               

            opts.queryParams['licenseStatusId'] = licenseStatusId;
            opts.queryParams['productTypeId'] = productTypeId;
            opts.queryParams['cargoTypeId'] = 0;
            grdTrafficLicenseList.datagrid('reload');

        }
        //$(document).ready(function () {
        //    restrictAccess();
        //});
    
    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>