﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
        #technicalLicPreviewBtn {
            width: 100%;
            height: auto;
            max-width: 350px; /* تنظیم عرض حداکثر */
            max-height: 450px; /* تنظیم ارتفاع حداکثر */
        }
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height: 500px; width: 100%;">
        <div data-options="region:'center',title:'چک اپراتوری'">
            <table id="grdLicensingCarList">

                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'Id', sortable:'true', width:80,type:'integer'">ردیف</th>
                        <th data-options="field:'ServiceMISPlate', sortable:'true', width:200">پلاک</th>
                        <th data-options="field:'TrafficDate', sortable:'true', width:200">تاریخ تردد</th>
                        <th data-options="field:'OperationStatusTitle', sortable:'true', width:200">وضعیت بررسی </th>
                        <th data-options="field:'VehicleTypeTitle', sortable:'true', width:200">نوع خودرو </th>
                        <th data-options="field:'ClientTypesClientTypeTitle', sortable:'true', width:200">منبع</th>
                        <th data-options="field:'ServiceVehicleTypeRate', sortable:'true', width:200">درصد تشخیص نوع خودرو</th>

                    </tr>
                </thead>
            </table>
            <div id="gridtoolbarLicensingCarList" style="padding: 2px 5px;">
                <div style="padding: 2px 5px;">

                    <a href="#" class="easyui-linkbutton" onclick="showDetailes()" iconcls="icon-display">نمایش اطلاعات</a>

                    <input tabindex="4" id="txtIranPlateNoCarList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                    <span>ایران</span>
                    <input tabindex="3" id="txtThreePlateNoCarList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                    <select tabindex="2" id="drpTwoPlateNoCarList" class="easyui-combobox" data-options="width:'70px'">
                        <option value="-1" selected="selected"></option>
                        <option value="01">الف</option>
                        <option value="02">ب</option>
                        <option value="04">ت</option>
                        <option value="06">ج</option>
                        <option value="07">چ-ژ</option>
                        <option value="10">د</option>
                        <option value="15">س</option>
                        <option value="17">ص</option>
                        <option value="19">ط</option>
                        <option value="21">ع</option>
                        <option value="24">ق</option>
                        <option value="27">ل</option>
                        <option value="28">م</option>
                        <option value="29">ن</option>
                        <option value="30">و</option>
                        <option value="31">هـ</option>
                        <option value="32">ی</option>
                        <option value="33">D</option>
                        <option value="34">S</option>

                    </select>

                    <input tabindex="1" type="text" id="txtOnePlateNoCarList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">

                    <select id="drpStatusChecked" class="easyui-combobox" name="forwaed" style="width: 15%;" data-options="label:'وضعیت بررسی :'">
                        <option value="0">همه</option>
                        <option value="1">بررسی شده  </option>
                        <option value="2">بررسی نشده </option>
                    </select>

                    از تاریخ :<input id="fromDate" class="dpTextBox dpTextBox-Invalid" style="width: 100px; background-color: antiquewhite;">
                    <input hidden id="txtFromDateVal" />
                    تا تاریخ :<input id="toDate" class="dpTextBox dpTextBox-Invalid" style="width: 100px; background-color: antiquewhite;">
                    <input hidden id="txtToDateVal" />

                    <a onclick="searchCarListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                    <a onclick="CarList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                    <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
                </div>

            </div>

        </div>
        <div id="dlgViewDetails" class="easyui-dialog" style="width: 700px; height: 500px; padding: 10px 20px" closed="true" modal="true">


            <div class="col-md-4">
                <div class="form-group" style="display: flex;">
                    <div class="col-md-8 row" style="width: 100%">
                        <img id="vehiclePreviewBtn" data-caption="تصویر خودرو" data-magnify="gallery" data-src="" src="" alt="Loading...">
                        <img id="platePreviewBtn" data-caption="تصویرپلاک" data-magnify="gallery" data-src="" src="" alt="Loading...">
                    </div>

                </div>
            </div>
            <br />
            <div class="easyui-panel" title="اطلاعات پردازش شده" style="width: 100%;" data-options="collapsible:true">

                <div style="margin: 10px 0;">

                    <input id="txtServiceMISPlate" labelwidth="140" style="width: 300px" class="easyui-textbox" data-options="label:'پلاک:',width:'390px'">
                    <input id="txtServiceOcrRate" labelwidth="140" style="width: 300px" class="easyui-textbox" data-options="label:'درصد تشخیص پلاک:',width:'390px'">
                </div>
                <div style="margin: 10px 0;">

                    <input id="txtTrafficDate" labelwidth="140" style="width: 300px" class="easyui-textbox" data-options="label:'تاریخ تردد:',width:'390px'">
                    <input id="txtServiceVehicleTypeRate" labelwidth="140" style="width: 300px" class="easyui-textbox" data-options="label:'درصد تشخیص خودرو:',width:'390px'">
                </div>
            </div>
            <div class="easyui-panel" title="تصحیح اطلاعات" style="width: 100%;" data-options="collapsible:true">

                <div style="margin: 10px 0;">
                </div>
                <div style="margin: 10px 0;">

                    <input id="drpVehicleType" labelwidth="140" style="width: 300px" class="easyui-combobox" data-options="label:'نوع خودرو:',width:'390px'">
                    <input id="drpCarUsage" labelwidth="140" style="width: 300px" class="easyui-combobox" data-options="label:'کاربری خودرو:',width:'390px'">
                </div>
            </div>

            <div style="text-align: center">
                <br />
                <a href="javascript:void(0)" class="easyui-linkbutton c6" style="width: 90px" iconcls="icon-ok" onclick="SaveChecked()">ثبت</a>
                <a href="javascript:void(0)" class="easyui-linkbutton" onclick="javascript: $('#dlgViewDetails').dialog('close');" style="width: 90px">انصراف</a>
            </div>
        </div>





        <div id="winCarEdit" title="Basic Window"></div>
        <div id="winLicensing" title="Basic Window">
        </div>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
            var grdLicensingCarList = $('#grdLicensingCarList');
            var winCarEdit = $('#winCarEdit');
            var winLicensing = $('#winLicensing');
            var today = '';
            var minus = 0;
            var plus = 0;
            var formattedVal = '';
            function openEditCarsWindow(url) {
                winCarEdit.window('open');
                winCarEdit.find('#iframeCarEdit').remove();
                var iframeEdit = $('<iframe id="iframeCarEdit" frameborder=0 style="width:99%" />');
                iframeEdit.appendTo(winCarEdit);
                iframeEdit.height(450);
                iframeEdit.attr('src', url);
            }
            $(function () {

               

                    $('#drpCarUsage').combobox({
                        method: 'get',
                        url: '/CoreServices/API/Base/CarUsages',
                        valueField: 'CarUsageId',
                        textField: 'Title',
                        multiple: false,
                        width: '250px',
                        editable: false,
                        labelWidth: '120px',
                        onLoadSuccess: function () {

                        }
                    });

                    $('#drpVehicleType').combobox({
                        method: 'get',
                        url: '/CoreServices/API/Base/CarUsages',
                        valueField: 'CarUsageId',
                        textField: 'Title',
                        multiple: false,
                        width: '250px',
                        editable: false,
                        labelWidth: '120px',
                        onLoadSuccess: function () {

                        }
                    });

                //$('#fromDate').datepicker();
                //$('#toDate').datepicker();

                $.ajax({
                    url: '/CoreServices/API/Shared/GetDate?diffDay=0',
                    type: 'GET',
                    contentType: 'application/json',
                    data: { diffDay: 0 },
                    success: function (data) {

                        $('#fromDate').val(data);
                        $('#toDate').val(data);
                        today = data;
                    },
                    error: function (xhr, textStatus, errorThrown) {
                    }
                });
            });
            //function showDetailes() {
            //    var row = grdLicensingCarList.datagrid('getSelected');
            //    if (row == null) {
            //        $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
            //        return;
            //    }
            // /*   $('#dlgViewDetails').dialog('open').dialog('center').dialog('setTitle', 'به روز رسانی');*/
             
            //    fetchImageFromAPI(row.id);

            //}

            $(function () {
                plaqueValue = getPlateNo(false, 'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
                if (plaqueValue === 'error')
                    return;

                var StatesList = $('#drpStatusChecked').combobox('getValue');
                grdLicensingCarList.datagrid({
                    //title: '',
                    url: '/Traffic/API/CheckOperator/CheckOperatorList',
                    filterBtnPosition: 'left',
                    remoteFilter: true,
                    method: 'Get',
                    view: detailview,
                    //async:true,
                    fit: true,
                    fitColumns: true,
                    pagination: true,
                    pageSize: 15,
                    pageList: [15, 50, 100, 99999],
                    rownumbers: true,
                    height: 248,
                    sortName: 'Id',
                    sortOrder: 'desc',
                    toolbar: '#gridtoolbarLicensingCarList',
                    height: $(window).height() - 155,
                    detailFormatter: function (rowIndex, rowData) {

                        return '<div class="container-fluid" style="background-color:#DBFFFF;direction:rtl !important"><div class="row"><div class="col-1"> بررسی توسط :</div><div class="col-3">'
                            + formatNullRemover(rowData.CheckedByUserName) + '</div><div class="col-1">تاریخ بررسی : </div><div class="col-3">' + formatNullRemover(rowData.CheckedDate) + '</div></div></div>';
               
                            

                    },

                    queryParams: {
                        plateNo: '0',
                        trafficDatefrom: '',
                        trafficDateTo: '',
                        checkedState: '0',

                    }


                });

                var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
                var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
                var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

                var filterOnSelectValue = null;
                var filterOnSelectField = null;

                grdLicensingCarList.datagrid('enableFilter', [


                    {
                        field: 'VehicleTypeTitle',
                        type: 'text',
                        op: textOp,
                    },

                    {
                        field: 'TrafficDate',
                        type: 'text',
                        op: dateboxOp,
                    },
                    {
                        field: 'Id',
                        type: 'text',
                        op: dateboxOp,
                    },
                    {
                        field: 'OperationStatusTitle',
                        type: 'text',
                        op: dateboxOp,
                    },
                    {
                        field: 'ClientTypesClientTypeTitle',
                        type: 'text',
                        op: dateboxOp,
                    },
                ]);

            });
            function showDetailes() {
                var row = grdLicensingCarList.datagrid('getSelected');
                if (row == null) {
                    $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                    return;
                }
                $('#txtServiceMISPlate').textbox('setValue', row.ServiceMISPlate);
                $('#txtServiceOcrRate').textbox('setValue', row.ServiceOcrRate);
                $('#txtTrafficDate').textbox('setValue', row.TrafficDate);
                $('#txtServiceVehicleTypeRate').textbox('setValue', row.ServiceVehicleTypeRate);
                $('#drpVehicleType').combobox('setValue', row.VehicleTypeId);
                $('#drpCarUsage').combobox('setValue', row.CarUsageId);
                $('#dlgViewDetails').dialog('open').dialog('center').dialog('setTitle', 'به روز رسانی');

                fetchImageFromAPI(row.Id);
                fetchImageFromAPI2(row.Id);
                
            }
       
            function fetchImageFromAPI(trafficId) {
                $.ajax({
                    url: '/Traffic/API/CheckOperator/TrafficVehiclePicture?trafficId=' + trafficId,
                    method: 'GET',
                    //data: { trafficId: trafficId },
                    success: function (response) {
                        if (response.IsSuccessful && response.ReturnValue && response.ReturnValue.FileContent) {
                            const fileContent = response.ReturnValue.FileContent;

                            // ایجاد یک URL داده
                            const imageUrl = `data:image/jpeg;base64,${fileContent}`;

                            // قرار دادن URL داده در ویژگی src تصویر
                            $('#vehiclePreviewBtn').attr('src', imageUrl);

                            // باز کردن دیالوگ
                            $('#dlgViewDetails').dialog('open').dialog('center').dialog('setTitle', 'به روز رسانی');
                        } else {
                            $.messager.alert('خطا', 'خطا در بارگذاری تصویر');
                        }
                    },
                    error: function () {
                        $.messager.alert('خطا', 'خطا در برقراری ارتباط با سرور');
                    }
                });
            }
            function fetchImageFromAPI2(trafficId) {
                $.ajax({
                    url: '/Traffic/API/CheckOperator/TrafficPlatePicture?trafficId=' + trafficId,
                    method: 'GET',
                    //data: { trafficId: trafficId },
                    success: function (response) {
                        if (response.IsSuccessful && response.ReturnValue && response.ReturnValue.FileContent) {
                            const fileContent = response.ReturnValue.FileContent;

                            // ایجاد یک URL داده
                            const imageUrl = `data:image/jpeg;base64,${fileContent}`;

                            // قرار دادن URL داده در ویژگی src تصویر
                            $('#platePreviewBtn').attr('src', imageUrl);

                            // باز کردن دیالوگ
                            $('#dlgViewDetails').dialog('open').dialog('center').dialog('setTitle', 'به روز رسانی');
                        } else {
                            $.messager.alert('خطا', 'خطا در بارگذاری تصویر');
                        }
                    },
                    error: function () {
                        $.messager.alert('خطا', 'خطا در برقراری ارتباط با سرور');
                    }
                });
            }
            //function populateTypeCategoryDropdown() {
            //    $.ajax({
            //        url: '/CoreServices/API/Base/CarUsages', // آدرس API
            //        method: 'GET',
            //        success: function (data) {
            //            var dropdown = $('#drpCarUsage');
            //            dropdown.empty(); // ابتدا محتوای فعلی فیلد را خالی می‌کنیم

            //            $.each(data, function (index, item) {
            //                dropdown.append($('<option>', {
            //                    value: item.CarUsageId, // مقدار value برای هر آیتم
            //                    text: item.Title // متن نمایشی برای هر آیتم
            //                }));
            //            });
            //        },
            //        error: function () {
            //            $.messager.alert('خطا', 'خطا در دریافت اطلاعات از سرور');
            //        }
            //    });
            //}
       
            function searchCarListOnDB() {
                plaqueValue = getPlateNo(false, 'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
                if (plaqueValue === 'error')
                    return;
                minus = 0;
                plus = 0;
                var opts = grdLicensingCarList.datagrid('options');
                opts.isBindOnLoad = true;
                opts.queryParams['PlateNo'] = plaqueValue;
                opts.queryParams['trafficDatefrom'] = $("#fromDate").val();
                opts.queryParams['trafficDateTo'] = $("#toDate").val();
                opts.queryParams['checkedState'] = $("#drpStatusChecked").combobox("getValue");
                grdLicensingCarList.datagrid('reload', opts.queryParams);

            }
            function CarList_clearFilter() {
                var minus = 0;
                var plus = 0;
                $('#txtOnePlateNoCarList').textbox('clear');
                $('#txtThreePlateNoCarList').textbox('clear');
                $('#txtIranPlateNoCarList').textbox('clear');
                $('#drpTwoPlateNoCarList').combobox('reset');
                $('#drpStatusChecked').combobox('reset');
            }

            function toExcel() {
                $('#grdLicensingCarList').datagrid('toExcel', 'dg.xls');
            }
    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>
