﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px;width:100%">
        <div data-options="region:'center',title:'نمایش اطلاعات مشکل کاربران'">
            <table id="grdRequestTickets">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'TicketId', sortable:'true', width:30">TicketId</th>
                        <th data-options="field:'UserName', sortable:'true', width:140">نام کاربری</th>
                        <th data-options="field:'NationalCode', sortable:'true', width:140">کد ملی</th>
                        <th data-options="field:'Title', sortable:'true', width:140">موضوع تیکت</th>
                        <th data-options="field:'VIN', sortable:'true', width:140">VIN</th>
                        <th data-options="field:'MISPlate', sortable:'true', width:120">شماره پلاک</th>
                        <th data-options="field:'CreateDate', sortable:'true', width:160">تاریخ درخواست</th>

                    </tr>
                </thead>
            </table>
            <div id="gridToolbarTiketsId" style="padding:2px 5px;">
                <div style="padding:2px 5px;">
                    <a href="#" class="easyui-linkbutton" onclick="showDetailsTikets()" iconCls="icon-display">نمایش اطلاعات</a>



                    <!--<a onclick="showIsForwarded()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">  ارجاع داده شده  </a>
                    <a onclick="showIsAnswered()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">  پاسخ داده شده  </a>-->


                    <select id="drpAnsweredStateId" class="easyui-combobox" name="answer" style="width:15%;" data-options="label:'وضعیت پاسخ :'">
                        <option value="0">همه</option>
                        <option value="1">پاسخ داده شده </option>
                        <option value="2">پاسخ داده نشده</option>
                    </select>
                    <select id="drpForwardStateId" class="easyui-combobox" name="forwaed" style="width:15%;" data-options="label:'وضعیت ارجاع :'">
                        <option value="0">همه</option>
                        <option value="1">ارجاع داده شده  </option>
                        <option value="2">ارجاع داده نشده </option>
                    </select>

                    <!--<input id="drpCategoryStateId" class="easyui-textbox" data-options="label:'موضوع خطا:'">-->
                    <select id="drpCategoryStateId" class="easyui-combobox" name="category" style="width:15%;" data-options="label:'موضوع خطا :'">
                    </select>
                    <select id="drpSecurityGroupId" class="easyui-combobox" name="forwaed" style="width:15%;" data-options="label:'کاربر فرستنده :'">
                    </select>
                    <a onclick="searchTicketsListDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                    <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
                </div>

            </div>

        </div>
    </div>
    <div id="winCarEdit" title="Basic Window"></div>
    <div id="winLicensing" title="Basic Window">
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>

        var grdRequestTickets = $('#grdRequestTickets');
        function openEditCarsWindow(url) {
            winCarEdit.window('open');
            winCarEdit.find('#iframeCarEdit').remove();
            var iframeEdit = $('<iframe id="iframeCarEdit" frameborder=0 style="width:99%" />');
            iframeEdit.appendTo(winCarEdit);
            iframeEdit.height(450);
            iframeEdit.attr('src', url);
        }
        function closeIframeEdit(isSuccess, message) {
            winCarEdit.window('close');

            if (isSuccess) {
                $.messager.show({
                    title: 'پیغام',
                    msg: message,
                    showType: 'show',
                    style: {
                        right: '',
                        //top: document.body.scrollTop + document.documentElement.scrollTop + 100,
                        bottom: ''
                    }

                });
                grdLicensingCarList.datagrid('reload');

            }

        }
        $(function () {

            $('#drpCategoryStateId').combobox({

                valueField: 'TicketCategoryId',
                textField: 'Title',
                multiple: false
            });
            $.ajax({
                url: '/CoreServices/API/Tickets/GetTicketSubSystems',
                type: 'GET',
                contentType: 'application/json',

                success: function (data) {

                    if (data) {


                        data.unshift({ TicketCategoryId: 0, Title: 'همه' });
                        $('#drpCategoryStateId').combobox('loadData', data);
                        $('#drpCategoryStateId').combobox('setValue', 0);
                    }
                }

            });

            /*  $('select#drpCategoryStateId').append('<option>newvalue</option>');*/


            $('#drpSecurityGroupId').combobox({

                valueField: 'SecurityGroupId',
                textField: 'Description',
                multiple: false,

            });

            $.ajax({
                url: '/CoreServices/API/SecurityGroups/SecurityGroupsList',
                type: 'GET',
                contentType: 'application/json',

                success: function (data) {

                    if (data) {


                        data.unshift({ SecurityGroupId: 0, Description: 'همه' });
                        $('#drpSecurityGroupId').combobox('loadData', data);
                        $('#drpSecurityGroupId').combobox('setValue', 0);



                    }
                },

            });



        });


        function searchTicketsListDB() {

            var opts = grdRequestTickets.datagrid('options');
            opts.isBindOnLoad = true;


            opts.queryParams['ticketCategoryId'] = $('#drpCategoryStateId').combobox('getValue');
            opts.queryParams['securityGroupId'] = $('#drpSecurityGroupId').combobox('getValue');
            opts.queryParams['answeredState'] = $('#drpAnsweredStateId').combobox('getValue');
            opts.queryParams['forwardState'] = $('#drpForwardStateId').combobox('getValue');
            grdRequestTickets.datagrid('reload', opts.queryParams);


        }
        function toExcel() {
            $('#grdRequestTickets').datagrid('toExcel', 'dg.xls');
        }

        $(function () {
            grdRequestTickets.initializeGrid({
                //title: '',
                //view: detailview,
                //filterBtnPosition: 'left',
                //remoteFilter: true,
                //method: 'get',
                //fit: true,
                //singleSelect: true,
                //collapsible: true,
                //fitColumns: true,
                //pagination: true,
                //pageSize: 15,
                //pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/Tickets/GetTicketsListFiltered',
                //rownumbers: true,
                sortName: 'TicketId',
                sortOrder: 'desc',
                toolbar: '#gridToolbarTiketsId',
                height: $(window).height() - 160,
                detailFormatter: function (rowIndex, rowData) {

                    return '<div class="container-fluid" style="background-color:#DBFFFF;direction:rtl !important"><div class="row"><div class="col-1"> پاسخ تیکت:</div><div class="col-3">'
                        + formatNullRemover(rowData.Response);
                },
                queryParams: {
                    subSystemId: 0,
                    securityGroupId: 0,
                    answeredState: 2,
                    forwardState: 0
                }
            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;

            grdRequestTickets.datagrid('enableFilter', [
                {
                    field: 'TicketId',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'UserName',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'VIN',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'Title',
                    type: 'text',
                    op: textOp,
                }
            ]);

        });


        //دکمه نمایش اطلاعات
        function showDetailsTikets() {

            var row = grdRequestTickets.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            openEditLicensingWindow('/AdminBaraneh/Tickets/TicketsRequest.aspx?ticketId=' + row['TicketId']);

        }
        function openEditLicensingWindow(url) {

            window.open(url);
        }



    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>