﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px;width:100%">
        <div data-options="region:'center',title:'نمایش اطلاعات مشکل کاربران'">
            <table id="grdRequestTickets">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'TicketId', sortable:'true', width:30">TicketId</th>
                        <th data-options="field:'UserName', sortable:'true', width:140">نام کاربری</th>
                        <th data-options="field:'Title', sortable:'true', width:140">موضوع تیکت</th>
                        <th data-options="field:'NationalCode', sortable:'true', width:140">کد ملی</th>
                        <th data-options="field:'VIN', sortable:'true', width:140">VIN</th>
                        <th data-options="field:'MISPlate', sortable:'true', width:120">شماره پلاک</th>
                        <th data-options="field:'CreateDate', sortable:'true', width:160">تاریخ درخواست</th>

                    </tr>
                </thead>
            </table>
            <div id="gridToolbarTiketsId" style="padding:2px 5px;">
                <div style="padding:2px 5px;">

                    <select id="drpAnsweredStateId" class="easyui-combobox" name="answer" style="width:15%;" data-options="label:'وضعیت پاسخ :'">
                        <option value="0">همه</option>
                        <option value="1">پاسخ داده شده </option>
                        <option value="2">پاسخ داده نشده</option>
                    </select>
                    <select id="drpCategoryStateId" class="easyui-combobox" name="category" style="width:15%;" data-options="label:'موضوع خطا :'">
                    </select>

                    <a onclick="searchTicketsListDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                    <a href="#" class="easyui-linkbutton" onclick="showDetailsLicenssing()" iconCls="icon-display">پروانه فعالیت </a>
                    <a href="#" class="easyui-linkbutton" onclick="showDetailsDriverLicensing()" iconCls="icon-display">پروانه اشتغال</a>
                    <a href="#" class="easyui-linkbutton" onclick="showDetailsCompanyLicensing()" iconCls="icon-display">پروانه بهره برداری</a>



                </div>

            </div>

        </div>
    </div>
    <div id="winCarEdit" title="Basic Window"></div>
    <div id="winLicensing" title="Basic Window">
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
        var winCarEdit = $('#winCarEdit');
        var winLicensing = $('#winLicensing');
        var grdRequestTickets = $('#grdRequestTickets');

        $(function () {

            $('#drpCategoryStateId').combobox({

                valueField: 'TicketCategoryId',
                textField: 'Title',
                multiple: false
            });
            $.ajax({
                url: '/CoreServices/API/Tickets/GetTicketSubSystems',
                type: 'GET',
                contentType: 'application/json',

                success: function (data) {

                    if (data) {


                        data.unshift({ TicketCategoryId: 0, Title: 'همه' });
                        $('#drpCategoryStateId').combobox('loadData', data);
                        $('#drpCategoryStateId').combobox('setValue', 0);
                    }
                }

            });






        });


        function searchTicketsListDB() {

            var opts = grdRequestTickets.datagrid('options');
            opts.isBindOnLoad = true;



            opts.queryParams['ticketCategoryId'] = $('#drpCategoryStateId').combobox('getValue');
            opts.queryParams['answeredState'] = $('#drpAnsweredStateId').combobox('getValue');

            grdRequestTickets.datagrid('reload', opts.queryParams);


        }


        $(function () {
            grdRequestTickets.datagrid({
                //title: '',
                view: detailview,
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: true,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/Tickets/GetTicketsListFiltered',
                rownumbers: true,
                sortName: 'TicketId',
                sortOrder: 'desc',
                toolbar: '#gridToolbarTiketsId',
                height: $(window).height() - 160,
                detailFormatter: function (rowIndex, rowData) {

                    return '<div class="container-fluid" style="background-color:#DBFFFF;direction:rtl !important"><div class="row"><div class="col-1"> پاسخ تیکت:</div><div class="col-3">'
                        + formatNullRemover(rowData.Response);
                },
                queryParams: {
                    subSystemId: 0,
                    securityGroupId: 0,
                    answeredState: 0,
                    forwardState: 0
                }
            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;

            grdRequestTickets.datagrid('enableFilter', [
                {
                    field: 'TicketId',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'UserName',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'Title',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'VIN',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'NationalCode',
                    type: 'text',
                    op: textOp,
                }
            ]);

        });
        function openEditCarsWindow(url) {
            winCarEdit.window('open');
            winCarEdit.find('#iframeCarEdit').remove();
            var iframeEdit = $('<iframe id="iframeCarEdit" frameborder=0 style="width:99%" />');
            iframeEdit.appendTo(winCarEdit);
            iframeEdit.height(450);
            iframeEdit.attr('src', url);
        }
        function closeIframeEdit(isSuccess, message) {
            winCarEdit.window('close');

            if (isSuccess) {
                $.messager.show({
                    title: 'پیغام',
                    msg: message,
                    showType: 'show',
                    style: {
                        right: '',
                        //top: document.body.scrollTop + document.documentElement.scrollTop + 100,
                        bottom: ''
                    }

                });
                grdLicensingCarList.datagrid('reload');

            }

        }
        function showDetailsCompanyLicensing() {

            var row = grdRequestTickets.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            window.open('/AdminBaraneh/Companies/CompanyRequestEdit.aspx?CompnayLicensingId=' + row["CompanyLicensingId"]);


        }
        function showDetailsLicenssing() {

            var row = grdRequestTickets.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            window.open('/AdminBaraneh/Cars/LicensingEditLMS.aspx?licensingId=' + row["LicensingId"]);

        }
        function showDetailsDriverLicensing() {
            var currentRow = grdRequestTickets.datagrid("getSelected");

            if (currentRow == null) {
                $.messager.alert("info", 'لطفا ابتدا یک راننده انتخاب کنید', "info");
                return;
            }

            window.open('/AdminBaraneh/Baraneh/Drivers/driverDetail.aspx?DriverLicenseId=' + currentRow.DriverlicensingId + '&DriverId=' + currentRow.DriverId);

        }




    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>