﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px">
        <div data-options="region:'center',title:'پیام های ارسال شده'">
            <table id="grdSmsList">
                <thead>
                    <tr>
                        <th data-options="field:'SentDateTime',type:'datebox', sortable:'true',width:40">تاریخ</th>
                        <th data-options="field:'MessageBody', sortable:'true',width:200">متن پیام</th>
                        <th data-options="field:'MobileNumber', sortable:'true',width:40,type:'integer'">موبایل</th>
                        <th data-options="field:'ToUserName', sortable:'true',width:40">کاربر</th>
                        <th data-options="field:'FromUserName', sortable:'true',width:40">ارسال کننده</th>
                        <th data-options="field:'SubSystemTite', sortable:'true',width:20">زیر سیستم</th>

                    </tr>
                </thead>
            </table>
            <div id="gridtoolbarSmsList" style="padding:2px 5px;">
                <div style="background-color:#f4f4f4;padding:2px 5px;">
                    <a id="btnPrint" onclick="print()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ</a>
                    <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>


                </div>

            </div>
        </div>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>

        var grdSmsList = $('#grdSmsList');
        function toExcel() {
            $('#grdSmsList').datagrid('toExcel', 'dg.xls');
        }


        grdSmsList.initializeGrid({
            //title: '',
            //filterBtnPosition: 'left',
            //remoteFilter: true,
            //method: 'get',
            //fit: true,
            //singleSelect: true,
            //collapsible: true,
            //fitColumns: true,
            //pagination: true,
            //rownumbers: true,
            //pageSize: 20,
            //pageList: [5, 10, 20, 50, 100, 99999],
            url: '/Sms/API/Panel/SentSmsList',
            sortName: 'SentDateTime',
            sortOrder: 'desc',
            toolbar: '#gridtoolbarSmsList',
            

        });



        $(function () {
            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;

            grdSmsList.datagrid('enableFilter', [
                {
                    field: 'MessageBody',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'MobileNumber',
                    type: 'text',
                    op: numberBoxOP,
                },
                {
                    field: 'ToUserName',
                    type: 'text',
                    op: textOp,
                }
                ,
                {
                    field: 'FromUserName',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'SubSystemTite',
                    type: 'text',
                    op: textOp,
                }


            ]);
        });

        function print() {

            var queryParam = {
                smsTypeId: 1
            };
            var opts = grdSmsList.datagrid('options');
            //OrderBy
            queryParam.orderby = opts.finalOrder;
            if (opts.filterRulesString)
                queryParam.filter = opts.filterRulesString;
            var recursiveEncoded = $.param(queryParam);

            window.open('/Reports/Print/PrintSmsList.html?' + recursiveEncoded);
        }


        //function searchMessageConfirm() {

        //    var val = 2;//تحویل شده
        //    var opts = grdSMSMain.datagrid('options');
        //    opts.queryParams['smsStatusId'] = val;
        //    grdSMSMain.datagrid('reload');
        //}
        //function searchMessageCancel() {

        //    var val = 3;//لغو شده
        //    var opts = grdSMSMain.datagrid('options');
        //    opts.queryParams['smsStatusId'] = val;
        //    grdSMSMain.datagrid('reload');
        //}
        //function searchMessageNewRequest() {

        //    var val = 1;//ارسال شده
        //    var opts = grdSMSMain.datagrid('options');
        //    opts.queryParams['smsStatusId'] = val;
        //    grdSMSMain.datagrid('reload');
        //}

        $(document).ready(function () {
            restrictAccess();
        });

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>