﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div class="easyui-layout" id="mainLayout" style="height:700px;width:100%">

        <div data-options="region:'center',title:'لیست مدیریت کاربران'">

            <table id="grdUserManageMent">
                <thead>
                    <tr>
                        <th data-options="field:'FullName',width:150">نام و نام خانوادگی</th>
                        <th data-options="field:'UserName',width:150">نام کاریری</th>
                        <th data-options="field:'LastLoginDate',width:150,type:'datebox'">آخرین ورود به سیستم</th>

                    </tr>
                </thead>
            </table>
            <div id="gridtoolbarUserManageMent" style="padding:2px 5px;">
                <a href="#" class="easyui-linkbutton" onclick="UserManager_newItem()" iconCls="icon-add">جدید</a>
                <a href="#" class="easyui-linkbutton" onclick="UserManager_editItem()" iconCls="icon-edit">ویرایش</a>
                <a href="#" class="easyui-linkbutton" onclick="UserManager_deleteItem()" iconCls="icon-cancel">حذف</a>
                <a href="#" class="easyui-linkbutton" onclick="UserManager_refreshItem()" iconCls="icon-reload">به روز رسانی</a>
                <!--<a id="btnPrint" onclick="print()" class="easyui-linkbutton" data-options="regio
                n:'center',iconCls:'icon-print'">چاپ</a>-->

            </div>
        </div>

    </div>




    <div id="dlg" class="easyui-dialog" style="width:550px;height:400px;padding:10px 20px"
         closed="true" buttons="#dlg-buttons">
        <div id="tabMainUser" class="easyui-tabs" style="width:100%;">
            <div title="مشخصات کاربری" style="padding:10px;">
                <form id="frmEdit" method="post" novalidate>

                    <table width="100%">
                        <tr>
                            <td style="width:30%; text-align:left;">
                                <label>نام کاربری:</label>
                            </td>
                            <td>
                                <input id="txtUsername" class="easyui-textbox" required="true" tipPosition="left" style="width:250px">
                            </td>
                            <td style="width:80px;height:23px;">
                                <a href="javascript:void(0)" id="btnGetInfo" class="easyui-linkbutton c6" iconCls="icon-reload" onclick="validteUser()">بازیابی</a>
                            </td>
                        </tr>
                        <tr>
                            <td style="width:30%; text-align:left;">
                                <label>نام و نام خانوادگی:</label>
                            </td>
                            <td>
                                <input id="txtFullName" class="easyui-textbox" required="true" tipPosition="left" style="width:250px">
                            </td>

                        </tr>
                        <tr>
                            <td style="width:30%; text-align:left;">
                                <label>سطح دسترسی:</label>
                            </td>
                            <td>
                                <select data-options="panelHeight:'auto', editable: false" id="drpGroups" required="true" class="easyui-combobox" style="width:250px">
                                    <option value="0">کاربر عادی</option>
                                    <option value="2">مدیرسیستم</option>
                                    <!--<option value="3">کاربر اتحادیه</option>-->
                                    <option value="4">کاربر سازمان</option>
                                    <option value="5">کارشناس</option>
                                    <option value="9">پلیس</option>

                                </select>
                            </td>
                        </tr>

                    </table>
                </form>
            </div>
            <div title="دسترسی فرم ها" style="padding:10px;">

                <table id="grdUserPermission" style="width:450px">
                    <thead>
                        <tr>

                            <th data-options="field:'ck',checkbox : true,width:300"></th>
                            <th data-options="field:'Description',width:280">فرم</th>
                            <!--<th data-options="field:'IsShow',width:70,align:'center',checkbox:true ,type:'boolean'">نمایش</th>
                            <th data-options="field:'IsEdit',width:70,align:'center',checkbox:true ,type:'boolean'">نمایش</th>-->


                            <th data-options="field:'IsShow',width:70,formatter:colIsShow,align:'center',editor:{type:'checkbox',options:{on:'فعال',off:'غیرفعال'}}">نمایش</th>
                            <th data-options="field:'IsEdit',width:70,formatter:colIsShow,align:'center',editor:{type:'checkbox',options:{on:'فعال',off:'غیرفعال'}}">ویرایش</th>

                        </tr>
                    </thead>
                </table>

            </div>
        </div>

    </div>

    <div id="dlg-buttons">
        <a href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-ok" onclick="save()" style="width:90px">ذخیره</a>
        <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlg').dialog('close')" style="width:90px">لغو</a>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
        var grdUserPermission = $('#grdUserPermission');
        var grdUserManageMent = $('#grdUserManageMent');
        var changeRowId = null;
        var editIndex = undefined;

        grdUserManageMent.datagrid({
            method: 'get',
            fit: true,
            remoteFilter: true,
            singleSelect: true,
            selectOnCheck: true,
            checkOnSelect: true,
            collapsible: true,
            fitColumns: true,
            pagination: true,
            pageSize: 15,
            pageList: [15, 50, 100, 99999],
            rownumbers: true,
            sortName: 'UserId',
            sortOrder: 'desc',
            toolbar: '#gridtoolbarUserManageMent',
            url: '/CoreServices/API/Users/GetList',
            onDblClickRow: function (index, row) {
                UserManager_editItem();
            }
        });

        function endEditing() {
            if (editIndex == undefined) { return true }
            if (grdUserPermission.datagrid('validateRow', editIndex)) {
                grdUserPermission.datagrid('endEdit', editIndex);
                editIndex = undefined;
                return true;
            } else {
                return false;
            }
        }
        function onClickCell(index, field) {
            if (editIndex != index) {
                if (endEditing()) {
                    grdUserPermission.datagrid('selectRow', index)
                        .datagrid('beginEdit', index);
                    var ed = grdUserPermission.datagrid('getEditor', { index: index, field: field });
                    if (ed) {
                        ($(ed.target).data('textbox') ? $(ed.target).textbox('textbox') : $(ed.target)).focus();
                    }
                    editIndex = index;
                } else {
                    setTimeout(function () {
                        grdUserPermission.datagrid('selectRow', editIndex);
                    }, 0);
                }
            }
        }
        function onEndEdit(index, row) {
            var ed = $(this).datagrid('getEditor', {
                index: index,
                field: 'productid'
            });
            //  row.productname = $(ed.target).combobox('getText');
        }
        var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
        var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
        var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

        var filterOnSelectValue = null;
        var filterOnSelectField = null;

        

        grdUserManageMent.datagrid('enableFilter', [
            {
                field: 'FullName',
                type: 'text',
                op: textOp,
            },
            {
                field: 'UserName',
                type: 'text',
                op: textOp,
            },
            {
                field: 'LastLoginDate',
                type: 'datebox',
                op: dateboxOp,
            },


        ]);

        function UserManager_refreshItem() {
            grdUserManageMent.datagrid('reload');

        }

        function UserManager_newItem() {
            $('#dlg').dialog('open').dialog('center').dialog('setTitle', 'جدید');
            $('#frmEdit').form('clear');

            reloadGridPermission(0);

        }
        function reloadGridPermission(changeRowId) {

            // لیست فرم ها در زمان ثبت جدید
            grdUserPermission.datagrid({
                method: 'get',
                singleSelect: false,
                onClickCell: onClickCell,
                onEndEdit: onEndEdit,
                //collapsible: true,
                fitColumns: false,
                url: '/CoreServices/API/Users/GetAllApplicationPages?userId=' + changeRowId, //Load Hame Form Ha

                onLoadSuccess: function (data) {

                    if (changeRowId == null)//user Id
                        return data;

                    //Load Dastresi haye karbar
                    $.ajax({
                        url: '/CoreServices/API/Users/GetUserPermission',
                        type: 'GET',
                        contentType: 'application/json',
                        data: { userId: changeRowId },
                        async: false,
                        success: function (data) {
                            //Select In Grid
                            var rows = grdUserPermission.datagrid('getRows');

                            for (var dg = 0; dg < rows.length; dg++) {

                                for (var i = 0; i < data.length; i++) {

                                    if (rows[dg].ApplicationPageId == data[i].ApplicationPageId) {

                                        grdUserPermission.datagrid('checkRow', dg);
                                        break;
                                    }
                                }
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            $.messager.progress('close');
                            alert('Error')
                        }
                    });

                }
            });
        }
        function UserManager_editItem() {
            $('#dlg').dialog('open').dialog('center').dialog('setTitle', 'ویرایش');
            $('#frmEdit').form('clear');

            var row = grdUserManageMent.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                $('#dlg').dialog('close');
                return;

            }
            changeRowId = row['UserId'];
            var userItem = {};
            $.ajax({
                url: '/CoreServices/API/Users/GetByUserId',
                type: 'GET',
                contentType: 'application/json',
                data: { userId: row['UserId'] },
                async: false,
                success: function (data) {
                    userItem = data;

                    $('#txtUsername').textbox('setValue', userItem.UserName);
                    $('#txtFullName').textbox('setValue', userItem.FullName);
                    $('#drpGroups').combobox('setValue', userItem.SecurityGroupId);
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.alert('Error', 'خطا در دریافت اطلاعات', 'error');
                }
            });

            reloadGridPermission(changeRowId);



        }

        function save() {

            grdUserPermission.datagrid('acceptChanges');
            if (!$('#frmEdit').form('validate')) {
                $.messager.alert('اخطار', 'لطفا موارد اجباری را وارد نمایید', 'اخطار');
                return;
            }

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            var userName = $('#txtUsername').textbox('getValue');
            var fullName = $('#txtFullName').textbox('getValue');
            var securityGroupId = $('#drpGroups').combobox('getValue');
            //var existRows = $('#drpEtehadiye').combobox('getValues');
            var userPermisssionIds = [];
            var userPermisssions = grdUserPermission.datagrid('getSelections');
            for (var i = 0; i < userPermisssions.length; i++)
                userPermisssionIds.push(userPermisssions[i].ApplicationPageId);
            userPermisssionStr = userPermisssionIds.join('_');


           
            var data = JSON.stringify({
                userPermisssions: userPermisssions,
                FullName: fullName,
                Username: userName,
                LastLoginDate: '',
                SecurityGroupId: securityGroupId,
                UserId: changeRowId

            });
            $.ajax({
                url: '/CoreServices/API/Users/Save',
                type: 'Post',
                async: false,
                contentType: 'application/json',
                data: data

                // users: user,
                // userPermisssionIds: userPermisssionStr,
                //userPermisssions: userPermisssions
                //etehadiyeIds: existRows
                ,
                success: function (data) {

                    if (data.IsSuccessful == true) {

                        $.messager.progress('close');
                        $('#dlg').dialog('close');
                        UserManager_refreshItem();
                        $.messager.show({
                            title: 'پیغام سیستم',
                            msg: data.Message,
                            timeout: 2000,
                            showType: 'slide',
                            style: {
                                right: '',
                                bottom: ''
                            }
                        });

                        // window.location.replace("AgencyEditSuccess.html");

                    }
                    else {
                        $.messager.progress('close');
                        $.messager.alert('اخطار', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                }
            });

        };

        function UserManager_deleteItem() {
            var row = grdUserManageMent.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                if (r) {

                    $.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                    $.ajax({
                        url: '/CoreServices/API/Users/Delete',
                        type: 'GET',
                        contentType: 'application/json',
                        data: { userId: row.UserId },
                        async: false,
                        success: function (data) {

                            if (data.IsSuccessful == true) {
                                $('#dlg').dialog('close');
                                grdUserManageMent.datagrid('reload');


                                $.messager.show({
                                    title: 'پیغام سیستم',
                                    msg: data.Message,
                                    timeout: 2000,
                                    showType: 'slide',
                                    style: {
                                        right: '',
                                        bottom: ''
                                    }
                                });


                            }
                            else {
                                $.messager.alert('اخطار', data.Message);
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            alert('Error')
                        }
                    });

                    $.messager.progress('close');
                }
            });

        }

        function validteUser() {

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            var userName = $('#txtUsername').textbox('getValue');

            $.ajax({
                url: '/CoreServices/API/Users/ValidateLdapUserName',
                type: 'GET',
                contentType: 'application/json',
                data: {
                    username: userName
                },
                success: function (data) {

                    if (data != "NoUserError") {

                        $.messager.progress('close');

                        $('#txtFullName').textbox('setValue', data);

                    }
                    else {
                        $.messager.progress('close');
                        $.messager.alert('اخطار', "چنین کاربری وجود ندارد", 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                }
            });

        };
        function print() {

            var queryParam = {

            };
            var opts = grdUserManageMent.datagrid('options');
            //OrderBy
            queryParam.orderby = opts.finalOrder;
            if (opts.filterRulesString)
                queryParam.filter = opts.filterRulesString;
            var recursiveEncoded = $.param(queryParam);

            window.open('/Reports/Print/PrintUserManageMent.html?' + recursiveEncoded);
        }
        function colIsShow(value) {

            if (value == false)
                return "غیرفعال";
            if (value == true) {
                return "فعال";
            }
            if (value == "غیرفعال") {
                return "غیرفعال";
            }
            if (value == "فعال") {
                return "فعال";
            }
        }

        $(document).ready(function () {
            restrictAccess();
        });

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>