﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px;width:100%;">

        <div data-options="region:'center',title:'لیست وضعیت خودروها'">

            <table id="grdDeActiveVehicle">
                <thead>
                    <tr>
                        <th data-options="field:'VIN',width:150">VIN</th>
                        <th data-options="field:'MISPlaque',width:150">پلاک</th>
                        <th data-options="field:'DeActiveDate',width:150,type:'datebox'">تاریخ غیر فعال شدن</th>
                        <th data-options="field:'ActiveDate',width:150,type:'datebox'">تاریخ فعال شدن</th>

                    </tr>
                </thead>
            </table>
            <div id="gridtoolbarDeActiveVehicle" style="padding:2px 5px;">
                <input id="txtVin" class="easyui-textbox" style="width:300px;height:25px " data-options="label:'VIN:'">
                <input tabindex="4" id="txtIranPlateNoCarList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                <span>ایران</span>
                <input tabindex="3" id="txtThreePlateNoCarList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                <select tabindex="2" id="drpTwoPlateNoCarList" class="easyui-combobox" data-options="width:'60px'">
                    <option value="-1" selected="selected"></option>
                    <option value="01">الف</option>
                    <option value="02">ب</option>
                    <option value="04">ت</option>
                    <option value="06">ج</option>
                    <option value="07">چ-ژ</option>
                    <option value="10">د</option>
                    <option value="15">س</option>
                    <option value="17">ص</option>
                    <option value="19">ط</option>
                    <option value="21">ع</option>
                    <option value="24">ق</option>
                    <option value="27">ل</option>
                    <option value="28">م</option>
                    <option value="29">ن</option>
                    <option value="30">و</option>
                    <option value="31">هـ</option>
                    <option value="32">ی</option>
                    <option value="33">D</option>
                    <option value="34">S</option>

                </select>
                <input tabindex="1" type="text" id="txtOnePlateNoCarList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">
                <a href="#" class="easyui-linkbutton" onclick="deActiveVehicle()" iconCls="icon-action">عملیات غیر فعال کردن خودرو</a>
                <a href="#" class="easyui-linkbutton" onclick="activeVehicle()" iconCls="icon-action">عملیات فعال کردن خودرو</a>
                <a href="#" class="easyui-linkbutton" onclick="deActiveVehicleDisplay()" iconCls="">نمایش خودروهای غیرفعال</a>
                <a href="#" class="easyui-linkbutton" onclick="refresh()" iconCls="icon-reload">به روز رسانی</a>
                <a href="#" class="easyui-linkbutton" onclick="deActiveVehicleClear()" iconCls="">حذف فیلتر</a>

            </div>
         </div>
         
        </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>

            setTimeout(function () {
                getid();
       
            }, 50);

            var globalvehicleId;
           
            function getid() {

               
                
                $.ajax({
                    url: '/CoreServices/API/Car/GetListDeActiveVehicles',
                    type: 'GET',
                    contentType: 'application/json',
                    
                    
                    success: function (data) {

                        globalvehicleId = data[0].VehicleId;
                        


                    },
                    error: function (xhr, textStatus, errorThrown) {
                   

                    }
                });

            }


           

            var grdDeActiveVehicle = $('#grdDeActiveVehicle');
           

        grdDeActiveVehicle.initializeGrid({
                //method: 'get',
                //fit:true,
                //singleSelect: true,
                //selectOnCheck: true,
                //checkOnSelect: true,
                //collapsible: true,
                //fitColumns: true,
                //pagination: true,
                //pageSize: 15,
                //pageList: [15, 50, 100, 99999],
                //rownumbers: true,
                sortName: 'DeActiveVehicleId',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarDeActiveVehicle',
                url: '/CoreServices/API/Car/GetListDeActiveVehicles',
                onDblClickRow: function (index, row) {
                   // UserManager_editItem();
                },
                queryParams: {
                    //isActiveVehicle: 3
                }
            });
           
           
            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;
            grdDeActiveVehicle.datagrid('enableFilter', [
   //{
   //    field: 'FullName',
   //    type: 'text',
   //    op: textOp,
   //},
    {
        field: 'VIN',
        type: 'text',
        op: textOp,
    },
      {
          field: 'MISPlaque',
          type: 'text',
          op: textOp,
      },
            {
                field: 'DeActiveDate',
                type: 'datebox',
                op: dateboxOp,
            },
             {
                 field: 'ActiveDate',
                 type: 'datebox',
                 op: dateboxOp,
             }


            ]);
            function deActiveVehicle() {

                var vin = $('#txtVin').textbox('getValue');

                plaqueValue = getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
                if (plaqueValue == 'error')
                    return;

                if (vin == "" || plaqueValue=="") {
                    $.messager.alert('اخطار به کاربر', 'VIN و پلاک خودرو را برای غیر فعال کردن وارد نمایید');
                    return;
                }
                $.ajax({
                    url: '/CoreServices/API/Car/DeActiveVehicleByVinPlate',
                    type: 'GET',
                    contentType: 'application/json',
                    data: {
                        vin: vin,
                        plateNo: plaqueValue
                    },
                    success: function (data) {

                        if (data.IsSuccessful == true) {
                            grdDeActiveVehicle.datagrid('reload');
                            $.messager.progress('close');

                            $.messager.alert('پیغام سیستمی', data.Message, 'info');

                        }
                        else {
                            $.messager.progress('close');
                            $.messager.alert('Warning', data.Message, 'error');
                        }

                    },
                    error: function (xhr, textStatus, errorThrown) {
                        showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        $.messager.progress('close');

                    }
                });

            }
            
           
            function activeVehicle()
            {
             

                var row = grdDeActiveVehicle.datagrid('getSelected');

                if (row == null) {
                    $.messager.alert('اخطار به کاربر', 'حد اقل یک رکورد را انتخاب نمایید');
                    return;
                }
                $.ajax({
                    url: '/CoreServices/API/Car/ActiveVehicle',
                    type: 'GET',
                    contentType: 'application/json',
                    data: JSON.stringify(row.VehicleId),
                    success: function (data) {

                        if (data.IsSuccessful == true) {
                            grdDeActiveVehicle.datagrid('reload');
                            $.messager.progress('close');
                           
                            $.messager.alert('پیغام سیستمی', data.Message, 'info');

                        }
                        else {
                            $.messager.progress('close');
                            $.messager.alert('Warning', data.Message, 'error');
                        }

                    },
                    error: function (xhr, textStatus, errorThrown) {
                        showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        $.messager.progress('close');

                    }
                });

            }
         
            function deActiveVehicleDisplay() {

                var val = 0;//خودروهای غیر فعال در سیستم
                var opts = grdDeActiveVehicle.datagrid('options');
                opts.queryParams['isActiveVehicle'] = val;
                grdDeActiveVehicle.datagrid('reload');

              

            }
            function refresh() {

                var val = 3;
                var opts = grdDeActiveVehicle.datagrid('options');
                opts.queryParams['isActiveVehicle'] = val;
                grdDeActiveVehicle.datagrid('reload');



            }
            function deActiveVehicleClear() {

                $('#txtVin').textbox('clear');
                $('#txtIranPlateNoCarList').textbox('clear');
                $('#txtThreePlateNoCarList').textbox('clear');
                $('#drpTwoPlateNoCarList').textbox('clear');
                $('#txtOnePlateNoCarList').textbox('clear');
 
                
            }


            $(document).ready(function () {
                restrictAccess();
            });

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>