﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    body > div.panel.combo-p {
            height: 350px;
/*            overflow-y: scroll;*/
        }

    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" >
        <div data-options="region:'center',title:'ساخت منو'">

            <table id="grdItems">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'ApplicationPageId', sortable:'true', width:60">کد صفحه </th>
                        <th data-options="field:'DevDesc', sortable:'true', width:60">تگ توضیحات </th>
                        <th data-options="field:'Name', sortable:'true', width:60">عنوان منو </th>
                        <th data-options="field:'Url', sortable:'true', width:150">لینک منو</th>
                        <th data-options="field:'OrderNo', sortable:'true', width:30">رتبه نمایش</th>
                        <th data-options="field:'IsMenuItem',formatter:showCheckbox, sortable:'true', width:30">نمایش در منو</th>
                    </tr>
                </thead>
            </table>
            <div id="gridToolBar" style="padding:2px 5px;">
                <a href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-message" onclick="dlgInsertItem()">درج منو</a>
                <a href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-message" onclick="dlgShowItem()">نمایش منو</a>
                <a href="javascript:void(0)" class="easyui-linkbutton" onclick="dlgDeleteItem()" iconcls="icon-cancel">حذف</a>

            </div>



        </div>
    </div>

    <div id="dlgForm" class="easyui-dialog" style="padding:10px 20px"
         closed="true">
        <form id="frmEdit" method="post" novalidate>

            <table>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label>  تک توضیحات:</label>
                    </td>

                    <td>
                        <input id="txtDescGroup" class="easyui-combobox" tipPosition="left" style=" height: 30px;">
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label> تک توضیحات:</label>
                    </td>

                    <td>
                        <input id="txtDesc" class="easyui-textbox" tipPosition="left" style="width: 520px; height: 30px; font-size: 16px; text-align: justify;">
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label> عنوان منو:</label>
                    </td>

                    <td>
                        <input id="txtTitle" class="easyui-textbox" tipPosition="left" style="width: 520px; height: 30px; font-size: 16px; text-align: justify;">
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label> لینک منو:</label>
                    </td>

                    <td>
                        <input id="txtLink" class="easyui-textbox" tipPosition="left" style="width: 520px; height: 30px; direction: ltr !important">
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label> کلاس آیکون:</label>
                    </td>

                    <td>
                        <input id="txtIconClass" class="easyui-textbox" tipPosition="left" style="width: 520px; height: 30px;">
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label> کلاس منو:</label>
                    </td>

                    <td>
                        <input id="txtMenuClass" class="easyui-textbox" tipPosition="left" style="width: 520px; height: 30px;">
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label> رتبه نمایش:</label>
                    </td>

                    <td>
                        <input id="txtOrder" class="easyui-textbox" tipPosition="left" style="width: 520px; height: 30px;">
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label> والد منو:</label>
                    </td>

                    <td>
                        <input id="txtParentMenu" class="easyui-combobox" tipPosition="left" style="  height: 30px;">
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label>نمایش در منو:</label>
                    </td>

                    <td>
                        <input id="chkIsMenuItem" tipPosition="left" type="checkbox">
                    </td>
                </tr>
            </table>
        </form>
        <a href="javascript:void(0)" id="btnSave" class="easyui-linkbutton c6" style="width:90px;" iconcls="icon-ok" onclick="saveItem()">ثبت</a>
        <a href="javascript:void(0)" id="btnEdit" class="easyui-linkbutton c6" style="width:90px" iconcls="icon-ok" onclick="editItem()">ثبت ویرایش</a>
        <a href="javascript:void(0)" class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript: $('#dlgForm').dialog('close');" style="width:90px">لغو</a>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
        function showCheckbox(value) {

            if (value == 1) {
                return '<input type="checkbox" checked disabled>';
            }
            else {
                return '<input type="checkbox" disabled>';
            }
        }
        $(function () {


            fillMenuItems();

        });

        $('#txtParentMenu').combobox({
            panelHeight: '100px',
            width: '300px',
            editable: true,
            labelWidth: '140px'

        });

        $('#txtDescGroup').combobox({
            panelHeight: '100px',
            width: '300px',
            editable: true,
            labelWidth: '140px'

        });

        function fillMenuItems() {

            $('#txtParentMenu').combobox({
                method: 'get',
                url: '/CoreServices/API/ApplicationPages/ParentList?SimpleList=true',
                valueField: 'ApplicationPageId',
                textField: 'TagedName',
                multiple: false,
            });


        $('#txtDescGroup').combobox({
            method: 'get',
            url: '/CoreServices/API/ApplicationPages/PagesTagGroups',
            valueField: 'Id',
            textField: 'DevDesc',
            multiple: false,
            onChange: function () {
               
                var selectedItem = $('#txtDescGroup').combobox('getText');
                $('#txtDesc').textbox('setValue', selectedItem);

                
            }
        });

        };

        function dlgInsertItem() {
            fillMenuItems();
            $('#txtTitle').textbox('clear');
            $('#txtDesc').textbox('clear');
            $('#txtLink').textbox('clear');
            $('#txtOrder').textbox('clear');
            $('#txtMenuClass').textbox('clear');
            $('#txtIconClass').textbox('clear');
            $('#dlgForm').dialog('open').dialog('center').dialog('setTitle', 'اضافه کردن منو');
            $("#btnEdit").hide();
            $("#btnSave").show();

        }

        function saveItem() {


            var devDesc = $('#txtDesc').textbox('getValue');
            var titlemenu = $('#txtTitle').textbox('getValue');
            var linkmenu = $('#txtLink').textbox('getValue');
            var orderNo= $('#txtOrder').textbox('getValue');
            var txtIconClass = $('#txtIconClass').textbox('getValue');
            var txtMenuClass = $('#txtMenuClass').textbox('getValue');
            var txtParentMenu = $('#txtParentMenu').combobox('getValue');
            var chkIsMenuItem = $("#chkIsMenuItem").prop("checked");

            if (txtParentMenu == "" || null) {


                txtParentMenu = 0;

            }


            data = {

                ApplicationPageId: 0,
                Name: titlemenu,
                Url: linkmenu,
                ParentId: txtParentMenu,
                IconClassType: txtIconClass,
                MenuClassType: txtMenuClass,
                IsMenuItem: chkIsMenuItem,
                DevDesc: devDesc,
                OrderNo:orderNo
            }

            $.ajax({
                url: '/CoreServices/API/ApplicationPages/PagesSave',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(data),
                success: function (data) {

                    if (data.IsSuccessful == true) {

                        $.messager.show({
                            title: 'پیغام سیستم',
                            msg: data.Message,
                            timeout: 1000,
                            showType: 'slide',
                            style: {
                                right: '',
                                bottom: ''
                            }
                        });
                        var opts = grdItems.datagrid('options');
                        opts.isBindOnLoad = true;
                        //opts.queryParams['catId'] = 1;
                        //opts.queryParams['type'] = 0;
                        grdItems.datagrid('reload', opts.queryParams);

                        $('#dlgForm').dialog('close');

                    }
                    else {
                        $.messager.progress('close');
                        $.messager.alert('Warning', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });
        }

        function dlgShowItem() {
            fillMenuItems();
            $("#btnEdit").show();
            $("#btnSave").hide();

            var row = grdItems.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            $('#dlgForm').dialog('open').dialog('center').dialog('setTitle', 'نمایش آیتم');


            $.ajax({
                url: '/CoreServices/API/ApplicationPages/PagesGetById',
                type: 'GET',
                contentType: 'application/json',
                data: { applicationPageId: row.ApplicationPageId },
                success: function (data) {

                    $('#txtTitle').textbox('setValue', data.Name);
                    $('#txtDesc').textbox('setValue', data.DevDesc);
                    $('#txtLink').textbox('setValue', data.Url);
                    $('#txtOrder').textbox('setValue', data.OrderNo);
                    $('#txtIconClass').textbox('setValue', data.IconClassType);
                    $('#txtMenuClass').textbox('setValue', data.MenuClassType);
                    $('#txtParentMenu').combobox('setValue', data.ParentId);
                    $('#chkIsMenuItem').prop('checked', data.IsMenuItem);

                    



                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });
        }

        function editItem() {
            //fillMenuItems();
            var row = grdItems.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            var devDesc = $('#txtDesc').textbox('getValue');
            var titlemenu = $('#txtTitle').textbox('getValue');
            var linkmenu = $('#txtLink').textbox('getValue');
            var orderNo = $('#txtOrder').textbox('getValue');
            var txtIconClass = $('#txtIconClass').textbox('getValue');
            var txtMenuClass = $('#txtMenuClass').textbox('getValue');
            
            var txtParentMenu = $('#txtParentMenu').combobox('getValue');

            var chkIsMenuItem = $("#chkIsMenuItem").prop("checked");

            if (txtParentMenu == "" || null) {


                txtParentMenu = 0;

            }


            data = {

                ApplicationPageId: row.ApplicationPageId,
                Name: titlemenu,
                Url: linkmenu,
                ParentId: txtParentMenu,
                IconClassType: txtIconClass,
                MenuClassType: txtMenuClass,
                IsMenuItem: chkIsMenuItem,
                DevDesc: devDesc,
                OrderNo:orderNo

            }

            $.ajax({
                url: '/CoreServices/API/ApplicationPages/PagesSave',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(data),
                success: function (data) {

                    if (data.IsSuccessful == true) {

                        $.messager.show({
                            title: 'پیغام سیستم',
                            msg: data.Message,
                            timeout: 1000,
                            showType: 'slide',
                            style: {
                                right: '',
                                bottom: ''
                            }
                        });
                        var opts = grdItems.datagrid('options');
                        opts.isBindOnLoad = true;
                        //opts.queryParams['catId'] = 1;
                        //opts.queryParams['type'] = 0;
                        grdItems.datagrid('reload', opts.queryParams);

                        $('#dlgForm').dialog('close');
                    }
                    else {
                        $.messager.progress('close');
                        $.messager.alert('Warning', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });

        }


        function dlgDeleteItem() {


            var row = grdItems.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            var selectlicense = row.ApplicationPageId;




            $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                if (r) {

                    //انتخاب اول
                    //$.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                    $.ajax({
                        url: '/CoreServices/API/ApplicationPages/PagesRemove',
                        type: 'GET',
                        contentType: 'application/json',
                        data: {
                            applicationPageId: selectlicense

                        },
                        async: false,
                        success: function (data) {

                            if (data.IsSuccessful == true) {
                                var opts = grdItems.datagrid('options');
                                opts.isBindOnLoad = true;
                                //opts.queryParams['catId'] = 1;
                                //opts.queryParams['type'] = 0;
                                grdItems.datagrid('reload', opts.queryParams);

                                //$.messager.alert('پیام سیستمی', data.Message, "info");

                                //showlist();


                            }
                            else {
                                $.messager.alert('Warning', data.Message);
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        }
                    });

                    $.messager.progress('close');
                }
            });

        }


        var grdItems = $('#grdItems');
        var dlgForm = $('#dlgForm');

        $(function () {

            dlgForm.window({
                width: '750',
                height: '450',
                closed: true,
                modal: true,


            });
            

            grdItems.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: true,
                // method: 'get',
                // fit: true,
                // singleSelect: false,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 99999,
                // pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/ApplicationPages/PagesList',
                rownumbers: true,
                sortName: 'ApplicationPageId',
                sortOrder: 'desc',
                toolbar: '#gridToolBar',
                queryParams: {
                    // ...existing code...
                }
            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            //var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;

            grdItems.datagrid('enableFilter', [
                {
                    field: 'DevDesc',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'Name',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'Url',
                    type: 'text',
                    op: textOp,
                }
                ,
                {
                    field: 'OrderNo',
                    type: 'text',
                    op: numberBoxOP,
                }
            ]);





        });

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>