﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
        body > div.panel.combo-p {
            height: 350px;
            /*            overflow-y: scroll;*/
        }
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout">
        <div data-options="region:'center',title:'مدیریت دسترسی وضعیت پروانه ها'">

            <table id="grdItems">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'LicensingStatusesUserAccessId', sortable:'true', width:60" hidden="hidden">کد دسترسی </th>
                        <th data-options="field:'UserName', sortable:'true', width:60">نام کاربری</th>
                        <th data-options="field:'FullName', sortable:'true', width:60">نام و نام خانوادگی</th>
                        <th data-options="field:'LicensingSubSystemTitle', sortable:'true', width:60">زیر سیستم</th>
                        <th data-options="field:'LicenseStatusTitle', sortable:'true', width:60">وضعیت پروانه</th>
                        <th data-options="field:'RequestByUser', sortable:'true', width:60">ایجاد شده توسط</th>
                        <th data-options="field:'CreateDate', sortable:'true', width:60">تاریخ ایجاد</th>
                        <th data-options="field:'IsShow',width:30,formatter:formatBoolean,align:'center'">نمایش</th>
                        <th data-options="field:'IsEdit',width:30,formatter:formatBoolean,align:'center'">ویرایش</th>
                    </tr>
                </thead>
            </table>
            <div id="gridToolBar" style="padding: 2px 5px;">
                <a href="javascript:void(0)" class="easyui-linkbutton c6" iconcls="icon-message" onclick="dlgInsertItem()">درج دسترسی</a>
                <a href="javascript:void(0)" class="easyui-linkbutton" onclick="deleteItem()" iconcls="icon-cancel">حذف</a>

                زیر سیستم پروانه  :<select id="drpSubSystems" class="easyui-combobox" data-options="width:'200px',panelHeight:'auto',editable:false">
                    <option value="0" selected="selected">همه</option>
                    <option value="1">پروانه بهره برداری</option>
                    <option value="2">پروانه فعالیت</option>
                    <option value="3">پروانه اشتغال</option>
                </select>
                <a href="#" class="easyui-linkbutton" onclick="searchAll()" iconcls="">جست و جو   </a>

            </div>



        </div>
    </div>

    <div id="dlgForm" class="easyui-dialog" style="padding: 10px 20px"
        closed="true">
        <form id="frmEdit" method="post" novalidate>

            <table>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label>زیر سیستم :</label>
                    </td>

                    <td>
                        <select id="drpDlgSubSystems" class="easyui-combobox" data-options="width:'200px',panelHeight:'auto',editable:false">
                            <option value="1" selected="selected">پروانه بهره برداری</option>
                            <option value="2">پروانه فعالیت</option>
                            <option value="3">پروانه اشتغال</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label>وضعیت پروانه :</label>
                    </td>

                    <td>
                        <select id="drpStatuses" class="easyui-combobox" data-options="width:'200px',panelHeight:'auto',editable:false">
                        </select>
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label>نام کاربری :</label>
                    </td>

                    <td>
                        <input id="txtUserName" class="easyui-textbox" tipposition="left" style="width: 520px; height: 30px; font-size: 16px; text-align: justify;">
                    </td>
                </tr>

                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label>دسترسی نمایش :</label>
                    </td>

                    <td>
                        <input id="chkIsShow" tipposition="left" type="checkbox" checked="checked">
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%; text-align: left;">
                        <label>دسترسی ویرایش :</label>
                    </td>

                    <td>
                        <input id="chkIsEdit" tipposition="left" type="checkbox">
                    </td>
                </tr>
            </table>
        </form>
        <a href="javascript:void(0)" id="btnSave" class="easyui-linkbutton c6" style="width: 90px;" iconcls="icon-ok" onclick="saveItem()">ثبت</a>
        <a href="javascript:void(0)" class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript: $('#dlgForm').dialog('close');" style="width: 90px">لغو</a>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>

        function dlgInsertItem() {
            //fillMenuItems();
            //$('#txtTitle').textbox('clear');
            //$('#txtDesc').textbox('clear');
            //$('#txtLink').textbox('clear');
            //$('#txtOrder').textbox('clear');
            //$('#txtMenuClass').textbox('clear');
            //$('#txtIconClass').textbox('clear');
            $('#dlgForm').dialog('open').dialog('center').dialog('setTitle', 'اضافه کردن آیتم');
            //$("#btnEdit").hide();
            //$("#btnSave").show();

        }

        function saveItem() {


            var userName = $('#txtUserName').textbox('getValue');
            var lsId = $('#drpStatuses').combobox('getValue');
            var isShow = $("#chkIsShow").prop("checked");
            var isEdit = $("#chkIsEdit").prop("checked");
            var subSystemId = $('#drpDlgSubSystems').combobox('getValue');
            if (lsId !== "0") {
                subSystemId = 0;
            }



            data = {

                UserName: userName,
                SubSystemId: subSystemId,
                LsId: lsId,
                IsShow: isShow,
                IsEdit: isEdit
            }

            $.ajax({
                url: '/CoreServices/API/LicensingStatucesUserAccess/AddStatusesUserAccess',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(data),
                success: function (data) {

                    if (data.IsSuccessful == true) {

                        $.messager.show({
                            title: 'پیغام سیستم',
                            msg: data.Message,
                            timeout: 1000,
                            showType: 'slide',
                            style: {
                                right: '',
                                bottom: ''
                            }
                        });
                        var opts = grdItems.datagrid('options');
                        opts.isBindOnLoad = true;
                        //opts.queryParams['catId'] = 1;
                        //opts.queryParams['type'] = 0;
                        grdItems.datagrid('reload', opts.queryParams);

                        $('#dlgForm').dialog('close');

                    }
                    else {
                        $.messager.progress('close');
                        $.messager.alert('Warning', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });
        }

        function deleteItem() {


            var row = grdItems.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            var selectItemId = row.LicenseStatusesUserAccessId;

            data = {
                LicenseStatusesUserAccessId: selectItemId
            };


            $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                if (r) {

                    //انتخاب اول
                    //$.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                    $.ajax({
                        url: '/CoreServices/API/LicensingStatucesUserAccess/RemoveStatusesUserAccess',
                        type: 'post',
                        contentType: 'application/json',
                        data: JSON.stringify(selectItemId),
                        async: false,
                        success: function (data) {

                            if (data.IsSuccessful == true) {
                                var opts = grdItems.datagrid('options');
                                opts.isBindOnLoad = true;
                                //opts.queryParams['catId'] = 1;
                                //opts.queryParams['type'] = 0;
                                grdItems.datagrid('reload', opts.queryParams);

                                //$.messager.alert('پیام سیستمی', data.Message, "info");

                                //showlist();


                            }
                            else {
                                $.messager.alert('Warning', data.Message);
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        }
                    });

                    $.messager.progress('close');
                }
            });

        }



        $('#drpDlgSubSystems').combobox({
            method: 'get',
            url: '/CoreServices/API/UsersAccess/SubSystems?withAll=false',
            valueField: 'SubSystemId',
            textField: 'Title',
            multiple: false,
        });

        $('#drpSubSystems').combobox({
            method: 'get',
            url: '/CoreServices/API/UsersAccess/SubSystems?withAll=true',
            valueField: 'SubSystemId',
            textField: 'Title',
            multiple: false,
        });


        $('#drpDlgSubSystems').combobox({
            onLoadSuccess: function () {
                $('#drpDlgSubSystems').combobox('setValue', '2');
            },
            onChange: function (param) {
                $('#drpStatuses').combobox({
                    method: 'get',
                    url: '/CoreServices/API/LicensingStatucesUserAccess/StatusesList?subSysetmId=' + param + '&withAll=true',
                    valueField: 'LsId',
                    textField: 'Title',
                    multiple: false,
                });
            }
        });
        $('#drpStatuses').combobox({
            onLoadSuccess: function () {
                $('#drpStatuses').combobox('setValue', '0');

            }

        });

        var grdItems = $('#grdItems');
        var dlgForm = $('#dlgForm');

        $(function () {

            dlgForm.window({
                width: '750',
                height: '250',
                closed: true,
                modal: true,


            });

            grdItems.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: true,
                // method: 'get',
                // fit: true,
                // singleSelect: true,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [15, 50, 100, 99999],
                // rownumbers: true,
                // loadMsg: 'Processing, please wait ...',
                url: '/CoreServices/API/LicensingStatucesUserAccess/StatusesAccessList',
                sortName: 'LicenseStatusesUserAccessId',
                sortOrder: 'desc',
                toolbar: '#gridToolBar',
                queryParams: {
                    subSystemId: 0
                }

            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            //var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;

            grdItems.datagrid('enableFilter', [
                {
                    field: 'UserName',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'FullName',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'RequestByUser',
                    type: 'text',
                    op: textOp,
                }

            ]);





        });

        function searchAll() {

            var opts = grdItems.datagrid('options');
            opts.isBindOnLoad = true;

            var subSystemId = $('#drpSubSystems').combobox('getValue');

            opts.queryParams['subSystemId'] = subSystemId;

            grdItems.datagrid('reload', opts.queryParams);
        }

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>
