﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <!-- Main content -->

    <div data-options="fit:true" class="easyui-layout" id="mainLayout">
        <div data-options="region:'center',title:'لیست واریزی به سازمان'">
            <table id="grdMain">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <!--<th data-options="field:'TransactionId', sortable:'true',width:50" hidden="hidden"></th>-->
                        <th data-options="field:'CreateDate', sortable:'true',width:30">تاریخ  </th>
                        <th data-options="field:'PlusAmount', sortable:'true',width:50,formatter:formatAmountPlus">واریز(ریال)</th>
                        <!--<th data-options="field:'MinusAmount', sortable:'true', width:160 ,formatter:amountMinusformat">برداشت(ریال)</th>-->
                        <th data-options="field:'IsSuccessful', sortable:'true',width:50, formatter:isSuccessful">نتیجه</th>
                        <th data-options="field:'NationalCodeId', sortable:'true',width:50">کد/شناسه ملی</th>
                        <th data-options="field:'FullName', sortable:'true'">نام و نام خانوادگی</th>
                        <th data-options="field:'TransactionSourceTitle', sortable:'true',width:50">منبع</th>
                        <th data-options="field:'AcceptorId', sortable:'true',width:50">شماره ترمینال</th>
                        <th data-options="field:'TransactionCode', sortable:'true',width:50">کد رهگیری سیستم</th>
                        <th data-options="field:'RetrievalReferenceNumber', sortable:'true',width:50">پیگیری بانک</th>
                        <!--<th data-options="field:'ReceiptImage', sortable:'true', width:160,formatter:receiptImage"> تصویر فیش واریزی </th>-->

                    </tr>
                </thead>
            </table>
            <div id="gridtoolbarMain" style="padding: 2px 5px;">
                <div style="padding: 2px 5px;">
                    <!--تراکنش های موفق  :
                    <input type="checkbox" class="custom-checkbox" id="justIsSuccess" />-->
                     از تاریخ :<input id="fromDate"class="dpTextBox dpTextBox-Invalid" style="width:100px;background-color:antiquewhite;">
                    تا تاریخ :<input id="toDate"class="dpTextBox dpTextBox-Invalid" style="width:100px;background-color:antiquewhite;">

                    <a onclick="searchCarListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                    <a onclick="CarList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                    <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
                    <a href="#" class="easyui-linkbutton" onclick="toPrint()" iconCls="icon-">چاپ</a>

                </div>
            </div>
        </div>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>

        var grdMain = $("#grdMain");


        var today = '';
        function toExcel() {
            $("#grdMain").datagrid('toExcel', {
                filename: 'transactions.xls',
                fields: ['CreateDate', 'PlusAmount', 'IsSuccessful', 'AcceptorId', 'RetrievalReferenceNumber'],
            });

        }


        function isSuccessful(val) {
            if (val == true) {
                return `<span style='color: white;background-color:green;padding:5px;'>موفق</span>`;
            }
            else if (val == true) {
                return `<span style='color: white;background-color:red;padding:5px;'>ناموفق</span>`;
            }
            else {
                return `<span style='color: white;background-color:red;padding:5px;'>مجموع</span>`;
            }
        }

        $(document).ready(function () {
            var today = null;

            grdMain.initializeGrid({
                //title: '',
                //filterBtnPosition: 'left',
                //remoteFilter: true,
                //method: 'get',
                //fit: true,
                //singleSelect: false,
                //collapsible: true,
                //fitColumns: true,
                //pagination: true,

                //pageSize: 20,
                //pageList: [14, 20, 50, 100, 99999],
                url: '/Payment/API/Transactions/IncomeList',
                //rownumbers: true,
                // singleSelect: false,
                sortName: 'TransactionId',
                //sortOrder: 'desc',
                toolbar: '#gridtoolbarMain',
                queryParams:
                {
                    fromDate: today,
                    toDate: today,

                },
                view: groupview,
                groupField: 'CreateDate',
                groupFormatter: function (value, rows) {
                    return value + ' - ' + (rows.length - 1) + ' تراکنش موفق در این صفحه  ';
                },
                onLoadSuccess: function (data) {
                    var groups = $(this).datagrid('groups');
                    for (var i = 0; i < groups.length; i++) {
                        var group = groups[i];
                        var unitcost = 0;
                        $.map(group.rows,
                            function (row) {
                                unitcost += row.PlusAmount;
                            });
                        $(this).datagrid('appendRow',
                            {
                                CreateDate: group.value,
                                PlusAmount: unitcost,

                            });
                    }


                },
                detailFormatter: function (rowIndex, rowData) {
                    
                    return '<div style="padding:5px">' +
                        '<p>Attribute: ' + rowData.attr1 + '</p>' +
                        '<p>Status: ' + rowData.status + '</p>' +
                        '</div>';
                }
            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;



            grdMain.datagrid('enableFilter', [
                {
                    field: 'PlusAmount',
                    type: 'text',
                    op: numberBoxOP,
                },

                {
                    field: 'AcceptorId',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'RetrievalReferenceNumber',
                    type: 'text',
                    op: textOp,
                }
                ,
                {
                    field: 'NationalCodeId',
                    type: 'text',
                    op: textOp,
                }
                ,
                {
                    field: 'FullName',
                    type: 'text',
                    op: textOp,
                }
                ,
                {
                    field: 'TransactionSourceTitle',
                    type: 'text',
                    op: textOp,
                }
                //,
                //{
                //    field: 'CreateDate',
                //    type: 'text',
                //    op: dateboxOp,
                //}
                
            ]);
        });

        function searchCarListOnDB() {

            minus = 0;
            plus = 0;
            var opts = grdMain.datagrid('options');
            opts.isBindOnLoad = true;

            //opts.queryParams['username'] = '';
            opts.queryParams['isSuccess'] = $("#justIsSuccess").prop("checked");
            opts.queryParams['fromDate'] = $("#fromDate").dpGetEnValue();
            opts.queryParams['toDate'] = $("#toDate").dpGetEnValue();
            opts.queryParams['productTypeId'] = $("#productTypeId").val();
            grdMain.datagrid('reload', opts.queryParams);

        }


        function CarList_clearFilter() {

            minus = 0;
            plus = 0;
            var opts = grdMain.datagrid('options');
            opts.isBindOnLoad = true;
            //opts.queryParams['username'] = '';
            opts.queryParams['isSuccess'] = '';
            opts.queryParams['fromDate'] = '';
            opts.queryParams['toDate'] = '';
            opts.queryParams['productTypeId'] = '';
            grdMain.datagrid('reload', opts.queryParams);

            $("#toDate").val("");
            $("#fromDate").val("");
        }

        function toPrint() {
            var fromDate = $("#fromDate").dpGetEnValue();
            var toDate = $("#toDate").dpGetEnValue();
            window.open('/Reports/Print/PrintIncome.html?FromDate=' + fromDate + '&ToDate=' + toDate);
            //$("#grdMain").datagrid('print', 'dg.xls');
        }

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>