﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    .combobox-item:hover {
            cursor: pointer !important;
        }

        .combobox-item-selected {
            background-color: rgb(35,110,202) !important;
            color: white !important;
            font-weight: bold;
        }
        #totalAmount {
            background-color: rgb(210 210 210);
            font-size:14px;
            width: 100%;
            height: 100%;
            justify-content: center;
            text-align: center;
            align-items: center;
            /* align-content: center; */
            /* align-self: center; */
            display: inline-flex;
        }

    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px">
        <div data-options="region:'center',title:'لیست درآمدها'">
            <table id="grdMain">
                <thead>
                    <tr>

                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'InvoiceId'" hidden></th>
                        <th data-options="field:'RequestId'" hidden></th>
                        <th data-options="field:'BillDate', sortable:'true', width:160">تاریخ</th>
                        <th data-options="field:'UserName', sortable:'true', width:160">نام کاربری</th>
                        <th data-options="field:'TotalAmount', sortable:'true', width:160">مبلغ کل فاکتور</th>
                        <th data-options="field:'InvoiceStatusId', sortable:'true', width:160,formatter:formatFactorField">وضعیت فاکتور</th>
                        <th data-options="field:'IsSuccessful', sortable:'true', width:160,formatter:formatSuccessfulField">وضعیت پرداخت</th>
                        <th data-options="field:'Description', sortable:'true', width:160">توضیحات</th>
                    </tr>
                </thead>
            </table>
            <div id="gridtoolbargrdMain" style="padding:2px 5px;">
              از تاریخ :<input id="fromdate"class="dpTextBox dpTextBox-Invalid" style="width:100px;background-color:antiquewhite;">
                                         <input hidden id="txtFromdateVal"/>
                    تا تاریخ :<input id="todate"class="dpTextBox dpTextBox-Invalid" style="width:100px;background-color:antiquewhite;">
                                         <input hidden id="txtTodateVal"/>
                نوع : <input class="easyui-combobox" id="drpProducts" style="width:250px" />

                <input tabindex="4" id="txtIranPlateNoCarList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                <span>ایران</span>
                <input tabindex="3" id="txtThreePlateNoCarList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                <select tabindex="2" id="drpTwoPlateNoCarList" class="easyui-combobox" data-options="width:'40px'">
                    <option value="-1" selected="selected"></option>
                    <option value="01">الف</option>
                    <option value="02">ب</option>
                    <option value="04">ت</option>
                    <option value="06">ج</option>
                    <option value="07">چ-ژ</option>
                    <option value="10">د</option>
                    <option value="15">س</option>
                    <option value="17">ص</option>
                    <option value="19">ط</option>
                    <option value="21">ع</option>
                    <option value="24">ق</option>
                    <option value="27">ل</option>
                    <option value="28">م</option>
                    <option value="29">ن</option>
                    <option value="30">و</option>
                    <option value="31">هـ</option>
                    <option value="32">ی</option>
                    <option value="33">D</option>
                    <option value="34">S</option>
                </select>
                <input tabindex="1" type="text" id="txtOnePlateNoCarList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">

                <a onclick="SearchOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو</a>
                <a onclick="ClearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                <a onclick="viewDetails()" class="easyui-linkbutton" data-options="region:'center',iconCls:''"> نمایش جزئیات </a>
                <a id="btnprintList" onclick="CreateFormPage('لیست درآمد روزانه باربرگ های صادر شده', $('#grdMain'))" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ</a>
                <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
            </div>
        </div>
    </div>


    <div id="dlgdetails" class="easyui-dialog" title="اقلام فاکتور" style="padding: 10px; width: 450px; min-height: 300px;" data-options="closed: true,iconCls:'icon-save',onResize:function(){$(this).dialog('center');}">

        <!-- جدول-->
         <table id="grdDetails">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'InvoiceItemId'" hidden></th>
                        <th data-options="field:'Title', sortable:'true', width:160">عنوان</th>
                        <th data-options="field:'Amount', sortable:'true', width:160">قیمت (ریال) </th>
                    </tr>
                </thead>
            </table>
            <div id="gridtoolbargrdDetails" style="padding:2px 5px;">
            </div>
        </div>
        <!-- Modal footer -->
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>



            var grdMain = $('#grdMain');
            var grdDetails = $("#grdDetails");

            function formatFactorField(val) {
                return val;
            }
            function formatSuccessfulField(val) {
                if (val == undefined) return '';
                if (val == true) {
                    return "باموفقیت پرداخت شد";
                } else  {
                    return "  پرداخت نشد";

                }
            }
            function viewDetails() {
                $('#dlgdetails').dialog('open').dialog('center');
                var row = grdMain.datagrid('getSelected');
                if (row == null) {
                    $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                    return;
                }
                grdDetails.datagrid({
                    //title: '',
                    filterBtnPosition: 'left',
                    remoteFilter: true,
                    method: 'get',
                    fit: true,
                    singleSelect: false,
                    collapsible: true,
                    fitColumns: true,
                    pagination: true,
                    pageSize: 15,
                    pageList: [15, 50, 100, 99999],
                    url: '/CoreServices/API/Invoices/GetInvoiceItems',
                    rownumbers: true,
                    sortName: 'InvoiceItemId',
                    sortOrder: 'desc',
                    toolbar: '#gridtoolbargrdDetails',
                    height: $(window).height() - 160,
                    queryParams:
                    {
                        invoiceId: row.InvoiceId
                    }
                });
            }
            function formatField(value) {
                if (value) {
                    value = value.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")
                }

                //return '<span style="font-family:adad !important">' + value + '</span>';
                return '<span >' + value + '</span>';
            }
            $(document).ready(function () {


                //$('#drpProducts').combobox("getValues")
                $('#drpProducts').combobox({
                    url: '/CoreServices/API/Invoices/GetInvoiceProducts',
                    method: 'get',
                    valueField: 'ProductId',
                    textField: 'Title',
                    multiple: true,

                });
                var totalSum = 0;
                grdMain.datagrid({
                    //title: '',
                    filterBtnPosition: 'left',
                    remoteFilter: true,
                    method: 'get',
                    fit: true,
                    singleSelect: false,
                    collapsible: true,
                    fitColumns: true,
                    pagination: true,
                    pageSize: 15,
                    pageList: [15, 50, 100, 99999],
                    url: '/CoreServices/API/Invoices/GetInvoices?aggregate=Total=sum(TotalAmount)',
                    rownumbers: true,
                    sortName: 'BillDate',
                    sortOrder: 'desc',
                    toolbar: '#gridtoolbargrdMain',
                    height: $(window).height() - 160,
                    onLoadSuccess: function (data) {
                     
                  //  for (i = 0; i < data.rows.length; i++) {
                  //      totalSum += data.rows[i].TotalAmount;
                  //  } 
                    
                     grdMain.datagrid('reloadFooter', [
                         { TotalAmount: '<span id="totalAmount"> مجموع : ' + data.aggregate.Total  +'<span>'},
                     ]);
                    },
                    queryParams: {
                        model: ''
                    },
                    showFooter: true,
                   
                });



                //$('#fromDate').datepicker();
                //$('#toDate').datepicker();

            });
            function toExcel() {
                $('#grdMain').datagrid('toExcel', 'dg.xls');
            }
            function ClearFilter() {

                var opts = grdMain.datagrid('options');
                opts.isBindOnLoad = true;
                opts.queryParams['fromDate'] = '';
                opts.queryParams['toDate'] = '';
                grdMain.datagrid('reload', opts.queryParams);

            }
            function SearchOnDB() {

                var opts = grdMain.datagrid('options');
                opts.isBindOnLoad = true;



                var invoiceQueryModel = {
                    fromDate: $("#fromDate").dpGetEnValue(),
                    todate: $("#toDate").dpGetEnValue(),
                    productIds: $('#drpProducts').combobox("getValues"),
                    plateNo: getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList')
                }

                opts.queryParams['model'] = invoiceQueryModel;
                grdMain.datagrid('reload', opts.queryParams);

            }
            function getPlateNoDataWhiteList() {

                if (onePlateNo == 0 || twoPlateNo == -1 || threePlateNo == 0 || iranPlateNo == 0) {
                    return '';
                }


                if (twoPlateNo.toString().length == 1)
                    twoPlateNo = '0' + twoPlateNo.toString();

                var result = '';
                //if (onePlateNo == 0) { result = '__'; } else { result = onePlateNo; }
                //if (twoPlateNo == -1) { result += '__'; } else { result += twoPlateNo; }
                //if (threePlateNo == 0) { result += '___'; } else { result += threePlateNo; }
                //if (iranPlateNo == 0) { result += '__'; } else { result += iranPlateNo; }


                result = onePlateNo.toString() + twoPlateNo.toString() + threePlateNo.toString() + iranPlateNo.toString();


                return result;
            }
            function printList() {

                var plaque = getPlateNoDataWhiteList();
                var voucherDate = $('#dpVoucherDateWhiteList').val();
                //if (plaque == '') {
                //    $.messager.alert('اخطار', 'پلاک را وارد نمایید');
                //    return;
                //}
                var queryParam =
                {
                    plaque: plaque,
                    voucherDate: voucherDate
                };

                var opts = grdMain.datagrid('options');
                //OrderBy
                queryParam.orderby = opts.finalOrder;
                if (opts.filterRulesString)
                    queryParam.filter = opts.filterRulesString;
                var recursiveEncoded = $.param(queryParam);

                window.open('/Reports/Print/printList.html?' + recursiveEncoded);
            }

            $(document).ready(function () {
                //      restrictAccess();
            });
    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>