﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    body > div.panel.combo-p
        {
            height:150px;
            overflow-y:scroll;
        }

    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px">
        <div data-options="region:'center',title:'مراکز نوزین'">

            <table id="grdItems">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'RequestId', sortable:'true', width:60" hidden="hidden">کد </th>
                        <th data-options="field:'SubSystem', sortable:'true', width:80">زیر سیستم </th>
                        <th data-options="field:'DevelopType', sortable:'true', width:25">نوع</th>
                        <th data-options="field:'Title', sortable:'true', width:230">توضیحات</th>
                        <th data-options="field:'RequestBy', sortable:'true', width:30">درخواست</th>
                        <th data-options="field:'CreateDate', sortable:'true', width:30">تاریخ درخواست</th>
                        <th data-options="field:'DevelopState', sortable:'true', width:45">وضعیت</th>
                        <th data-options="field:'AcceptBy', sortable:'true', width:30">پذیرش</th>
                        <th data-options="field:'AcceptDate', sortable:'true', width:30">تاریخ پذیرش</th>
                        <th data-options="field:'TimeConsume', sortable:'true', width:20">زمان اجرا</th>


                    </tr>
                </thead>
            </table>
            <div id="gridToolBar" style="padding:2px 5px;">
                <a href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-message" onclick="dlgInsertItem()">درج درخواست</a>
                <a href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-message" onclick="dlgInsertItem()">مشاهده جزییات</a>
                <a href="javascript:void(0)" class="easyui-linkbutton" onclick="dlgDeleteItem()" iconcls="icon-cancel">حذف</a>

            </div>



        </div>
    </div>

    <div id="dlgForm" class="easyui-dialog" style="width:670px;height:220px;padding:10px 20px"
         closed="true">
        <form id="frmEdit" method="post" novalidate>

            <table>
                <tr>
                    <td style="width:25%; text-align:left;">
                        <label> زیر سیستم:</label>
                    </td>

                    <td>
                        <input id="drpSubSystems" class="easyui-combobox" tipPosition="left" style="width:520px;height:30px;font-size: 16px;text-align: justify;">
                    </td>
                </tr>
                <tr>
                    <td style="width:25%; text-align:left;">
                        <label>ِنوع درخواست:</label>
                    </td>

                    <td>
                        <input id="drpDevelopTypes" class="easyui-combobox" tipPosition="left" style="width:520px;height:30px;font-size: 16px;text-align: justify;">
                    </td>
                </tr>

                <tr>
                    <td style="width:25%; text-align:left;">
                        <label>شرح :</label>
                    </td>

                    <td>
                        <input id="requestTitle" class="easyui-textbox" tipPosition="left" multiline="true" style="width:520px;height:100px;">
                    </td>
                </tr>
                

                
            </table>
        </form>
        <a href="javascript:void(0)" id="btnSave" class="easyui-linkbutton c6" style="width:90px;" iconcls="icon-ok" onclick="saveItem()">ثبت</a>
        <a href="javascript:void(0)" id="btnEdit" class="easyui-linkbutton c6" style="width:90px" iconcls="icon-ok" onclick="editItem()">ثبت ویرایش</a>
        <a href="javascript:void(0)"  class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript:$('#dlgForm').dialog('close')" style="width:90px">لغو</a>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
        function showCheckbox(value) {

            if (value == 1) {
                return '<input type="checkbox" checked disabled>';
            }
            else {
                return '<input type="checkbox" disabled>';
            }
        }
       

        


        function saveItem() {

            
            var centerWeighingCode = $('#txtCenterWeighingCode').textbox('getValue');
            var name = $('#txtName').textbox('getValue');
            var address = $('#txtAddress').textbox('getValue');
            var isActive = $("#chkIsActive").prop("checked");
            var isCompanyLicRequired = $("#chkCompanyLicRequired").prop("checked");

           

            data = {
                CenterWeighingId: 0,
                CenterWeighingCode: centerWeighingCode,
                Name: name,
                Address: address,
                IsActive: isActive,
                CompanyLicRequired: isCompanyLicRequired
            }

            $.ajax({
                url: '/Weighbridge/API/PCenterWeighing/AddUpdate',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(data),
                success: function (data) {

                    if (data.IsSuccessful == true) {

                        $.messager.show({
                            title: 'پیغام سیستم',
                            msg: data.Message,
                            timeout: 1000,
                            showType: 'slide',
                            style: {
                                right: '',
                                bottom: ''
                            }
                        });
                        var opts = grdItems.datagrid('options');
                        opts.isBindOnLoad = true;
                        //opts.queryParams['catId'] = 1;
                        //opts.queryParams['type'] = 0;
                        grdItems.datagrid('reload', opts.queryParams);

                        $('#dlgForm').dialog('close');

                    }
                    else {
                        $.messager.progress('close');
                        $.messager.alert('Warning', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });
        }

        function dlgShowItem() {
            
            $("#btnEdit").show();
            $("#btnSave").hide();

            var row = grdItems.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            $('#dlgForm').dialog('open').dialog('center').dialog('setTitle', 'نمایش آیتم');


            $.ajax({
                url: '/Weighbridge/API/PCenterWeighing/GetbyId',
                type: 'GET',
                contentType: 'application/json',
                data: { id: row.CenterWeighingId },
                success: function (data) {

                    $('#txtCenterWeighingCode').textbox('setValue', data.CenterWeighingCode);
                    $('#txtName').textbox('setValue', data.Name);
                    $('#txtAddress').textbox('setValue', data.Address);
                    $('#chkIsActive').prop('checked', data.IsActive);
                    $('#chkCompanyLicRequired').prop('checked', data.CompanyLicRequired);



                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });
        }

        function dlgInsertItem() {
            
            $('#txtCenterWeighingCode').textbox('clear');
            $('#txtName').textbox('clear');
            $('#txtAddress').textbox('clear');
            $('#dlgForm').dialog('open').dialog('center').dialog('setTitle', 'اضافه کردن مرکز');
            $("#btnEdit").hide();
            $("#btnSave").show();

        }

        function editItem() {
            
            var row = grdItems.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            var centerWeighingCode = $('#txtCenterWeighingCode').textbox('getValue');
            var name = $('#txtName').textbox('getValue');
            var address = $('#txtAddress').textbox('getValue');
            var isActive = $("#chkIsActive").prop("checked");
            var isCompanyLicRequired = $("#chkCompanyLicRequired").prop("checked");


            data = {
                CenterWeighingId: row.CenterWeighingId,
                CenterWeighingCode: centerWeighingCode,
                Name: name,
                Address: address,
                IsActive: isActive,
                CompanyLicRequired: isCompanyLicRequired
            }

            $.ajax({
                url: '/Weighbridge/API/PCenterWeighing/AddUpdate',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(data),
                success: function (data) {

                    if (data.IsSuccessful == true) {

                        $.messager.show({
                            title: 'پیغام سیستم',
                            msg: data.Message,
                            timeout: 1000,
                            showType: 'slide',
                            style: {
                                right: '',
                                bottom: ''
                            }
                        });
                        var opts = grdItems.datagrid('options');
                        opts.isBindOnLoad = true;
                        //opts.queryParams['catId'] = 1;
                        //opts.queryParams['type'] = 0;
                        grdItems.datagrid('reload', opts.queryParams);

                        $('#dlgForm').dialog('close');
                    }
                    else {
                        $.messager.progress('close');
                        $.messager.alert('Warning', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });

        }
        

        function dlgDeleteItem() {


            var row = grdItems.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            var selectedId = row.CenterWeighingId;




            $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                if (r) {

                    //انتخاب اول
                    //$.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                    $.ajax({
                        url: '/Weighbridge/API/PCenterWeighing/Delete',
                        type: 'GET',
                        contentType: 'application/json',
                        data: {
                            id: selectedId

                        },
                        async: false,
                        success: function (data) {

                            if (data.IsSuccessful == true) {
                                var opts = grdItems.datagrid('options');
                                opts.isBindOnLoad = true;
                                //opts.queryParams['catId'] = 1;
                                //opts.queryParams['type'] = 0;
                                grdItems.datagrid('reload', opts.queryParams);

                                //$.messager.alert('پیام سیستمی', data.Message, "info");

                                //showlist();


                            }
                            else {
                                $.messager.alert('Warning', data.Message);
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        }
                    });

                    $.messager.progress('close');
                }
            });

        }


        var grdItems = $('#grdItems');
        var dlgForm = $('#dlgForm');

        $(function () {

            

            $('#drpDevelopTypes').combobox({
                method: 'get',
                url: '/CoreServices/API/DevRequest/DevelopTypes',
                valueField: 'DevelopTypeId',
                textField: 'Title',
                multiple: false,
                //panelHeight: 'auto'
                

            });
            $('#drpSubSystems').combobox({
                method: 'get',
                url: '/CoreServices/API/DevRequest/SubSystems',
                valueField: 'SubSystemId',
                textField: 'Title',
                multiple: false,
                //panelHeight: 'auto'
                

            });

            dlgForm.window({
                width: '750',
                height: '300',
                closed: true,
                modal: true,


            });

            grdItems.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: true,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 99999,
                pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/DevRequest/Requests',
                rownumbers: true,
                //async: false,
                sortName: 'RequestId',
                sortOrder: 'desc',
                toolbar: '#gridToolBar',
                queryParams: {
                    
                }

            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
           var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;

            grdItems.datagrid('enableFilter', [
                {
                    field: 'SubSystem',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'DevelopType',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'Title',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'DevelopState',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'RequestBy',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'AcceptBy',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'CreateDate',
                    type: 'text',
                    op: dateboxOp,
                },
                {
                    field: 'AcceptDate',
                    type: 'text',
                    op: dateboxOp,
                },
              
            ]);





        });

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>