﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Content -------------- -->
           <div data-options="fit:true" class="easyui-layout" id="mainLayout" >

            <div data-options="region:'center',title:'لیست درخواست های پروانه بهره برداری'">
                <table id="grdCompanyRequestList">
                    <thead>
                        <tr>
                            <th field="ck" checkbox="true"></th>
                            <th data-options="field:'CompanyLicensingId', sortable:'true',width:25 ">ID</th>
                            <th data-options="field:'CompanyId', sortable:'true',width:120,hidden:true "> CompanyId</th>
                            <th data-options="field:'CompanyName', sortable:'true',width:120">نام شرکت</th>
                            <th data-options="field:'BrandName', sortable:'true',width:100,type:'datebox'">برند</th>
                            <th data-options="field:'UserName', sortable:'true',width:120,type:'integer'">نام کاربری</th>
                            <th data-options="field:'IsNewLicense', sortable:'true',width:80,formatter:formatIsNewField">نوع درخواست</th>
                            <th data-options="field:'CompanyLicensingCreateDate', sortable:'true',width:80,type:'datebox'">تاریخ درخواست </th>
                            <th data-options="field:'WorkFlowActionTypeTitle', sortable:'true',width:80,formatter:WfState">عملیات قبل</th>
                            <th data-options="field:'LicenseStatusTitle', sortable:'true',width:80">وضعیت درخواست</th>
                            <!--<th data-options="field:'LastUpdateDate',type: 'datebox', sortable:'true',width:100">به روز رسانی اطلاعات شرکت</th>-->
                            <th data-options="field:'ComanyActivityTitle',type: 'datebox', sortable:'true',width:100">نوع فعالیت </th>
                            <th data-options="field:'ManagerMobilePhone', sortable:'true',width:80">شماره موبایل</th>
                            
                            <th data-options="field:'LicenseNumber', sortable:'true',width:100,type:'integer'">شماره پروانه </th>
                            <th data-options="field:'LicenseDate', sortable:'true',width:100,type:'integer'">تاریخ صدور</th>
                            <!--<th data-options="field:'LastRejectDatetime', sortable:'true',width:100">تاریخ رد در خواست</th>
    <th data-options="field:'LastRejectBy',type: 'datebox', sortable:'true',width:100">رد درخواست توسط</th>-->
                            <th data-options="field:'IsPaid', sortable:'true', width:110,formatter:formatIsPaidView"> وضعیت پرداخت  </th>
                        </tr>
                    </thead>
                </table> 
                <div id="gridtoolbarLicenseOwnerList" style="padding:2px 5px;">
                    <a href="#" class="easyui-linkbutton" onclick="displayLicenseDetailLicenseOwnerList()" iconcls="icon-display">نمایش اطلاعات شرکت </a>
                    <a href="#" class="easyui-linkbutton" onclick="changeTypeRequest()" iconCls="icon-display">تغییر وضعیت درخواست </a>
                    نوع درخواست :<select id="drpIsRenew" class="easyui-combobox" data-options="width:'200px',panelHeight:'auto',editable:false">
                        <option value="-1" selected="selected">همه</option>
                        <option value="1"> صدور </option>
                        <option value="0"> تمدید</option>
                    </select>
                    وضعیت درخواست :<select id="drpLicenseStatus" class="easyui-combobox" data-options="width:'200px',panelHeight:'auto',editable:false">
                    </select>
                    نوع فعالیت :<select id="drpActivityType" class="easyui-combobox" data-options="width:'200px',panelHeight:'auto',editable:false">
                    </select>
                    <a href="#" class="easyui-linkbutton" onclick="searchAll()" iconcls="">   جست و جو   </a>
                    <a id="btnPrintLic" onclick="PrintLic()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ پروانه</a>
                    <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
                </div>
            </div>
        </div>
    <!-- -------------- End of Page Content -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->
    
<script>

    
        //restrictAccess();
        function toExcel() {
            $('#grdCompanyRequestList').datagrid('toExcel', 'dg.xls');
    }


    function WfState(rowIndex, rowData) {
        if (rowData.WorkFlowActionTypeId === 0) {
            return `<span style='color:red'> رد شده </span>`;
        }
        return rowData.WorkFlowActionTypeTitle
    }



        
        var grdCompanyRequestList = $('#grdCompanyRequestList');

        $(function () {

           
            $('#drpActivityType').combobox({
                method: 'get',
                url: '/CoreServices/API/Base/CompanyActivityTypes?withAll=true',
                valueField: 'CompanyActivityTypeId',
                textField: 'Title',
                multiple: false,
            });

            $('#drpLicenseStatus').combobox({
                method: 'get',
                url: '/CoreServices/API/UsersAccess/AccessLicenseStatuses?subSystemId=1',
                valueField: 'LicenseStatusId',
                textField: 'LicenseStatusTitle',
                multiple: false,
            });

            $('#drpActivityType').combobox('setValue', '0');
            $('#drpLicenseStatus').combobox('setValue', '0');

            grdCompanyRequestList.initializeGrid({
                //title: '',
                view: detailview,
                //filterBtnPosition: 'left',
                //remoteFilter: true,
                //method: 'get',
                //fit: true,
                //singleSelect: true,
                //collapsible: true,
                //fitColumns: true,
                //pagination: true,
                //pageSize: 20,
                //pageList: [5, 10, 20, 50, 100, 99999],
                url: '/Companies/API/Companies/CompanyLicensingList',
                /*rownumbers: true,*/
                sortName: 'CompanyLicensingId',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarLicenseOwnerList',
                //singleSelect: true,
                //detailFormatter: function(rowIndex, rowData) {
                //        //return '<table style="width: 100%" bgcolor="#DBFFFF" border="0" ><tr><td class="innerTable ">علت رد :</td><td>' + rowData.LastRejectDesc + '</td><td class="innerTable ">رد شده توسط:</td><td>' + rowData.LastRejectBy + '</td><td class="innerTable ">تاریخ رد :</td><td>' + rowData.LastRejectDatetime + '</td><td class="innerTable ">تاریخ اولین تایید  :</td><td>' + rowData.FirstStateAcceptedDate + '</td></tr><tr><td class="innerTable ">تایید شده توسط:</td><td>' + rowData.IsFirstStateAccepted + '</td><td class="innerTable ">تاریخ دومین تایید  :</td><td>' + rowData.SecondStateAcceptedDate + '</td><td class="innerTable ">تایید شده توسط :</td><td>' + rowData.IsSecondStateAccepted + '</td><td></td><td></td><td>&nbsp;</td><td>&nbsp;</td></tr></table>';
                //    return '<div style="background-color: #DBFFFF "><div class="row"><div class="col-md-3">تاریخ تایید کارشناس :' + formatNullRemover(rowData.FirstStateAcceptedDate) + '</div><div class="col-md-3">تایید شده توسط :' + formatNullRemover(rowData.FirstStateChangeBy) + '</div><div class="col-md-3"></div></div><div class="row"><div class="col-md-3">تاریخ تایید مدیر :' + formatNullRemover(rowData.SecondStateAcceptedDate) + '</div><div class="col-md-3">تایید شده توسط :' + formatNullRemover(rowData.SecondStateChangeBy) + '</div><div class="col-md-3"></div></div><div class="row"><div class="col-md-3">تاریخ رد درخواست :' + formatNullRemover(rowData.LastRejectDatetime) + '</div><div class="col-md-3">رد شده توسط :' + formatNullRemover(rowData.LastRejectBy) + '</div><div class="col-md-3">علت رد درخواست : ' +formatNullRemover(rowData.LastRejectDesc)+'</div></div></div>';
                //},
                detailFormatter: function (index, row) {
                    return '<div style="padding:2px"><table class="ddv"></table></div>';
                },
                onExpandRow: function (index, row) {
                    var ddv = $(this).datagrid('getRowDetail', index).find('table.ddv');
                    ddv.datagrid({
                        url: '/Companies/API/Companies/EventsByCompanyLicensingId?CompanyLicensingId=' + row.CompanyLicensingId,
                        method: 'get',
                        fitColumns: true,
                        singleSelect: true,
                        rownumbers: true,
                        loadMsg: 'صبر کنید - درحال بارگذرای',
                        pagination: true,
                        pageSize: 10,
                        sortName: 'EventId',
                        height: 'auto',
                        columns: [[
                            { field: 'EventDate', title: 'تاریخ', width: 100 },
                            { field: 'FullName', title: 'کاربر', width: 120 },
                            { field: 'ActionTitle', title: 'عملیات', width: 120 },
                            { field: 'StatusFrom', title: 'وضعیت اولیه', width: 120 },
                            { field: 'StatusTo', title: 'وضعیت نهایی', width: 120 },
                            { field: 'ActionDescription', title: 'توضیحات', width: 300 }
                        ]],
                        onResize: function () {
                            grdCompanyRequestList.datagrid('fixDetailRowHeight', index);
                        },
                        onLoadSuccess: function () {
                            setTimeout(function () {
                                grdCompanyRequestList.datagrid('fixDetailRowHeight', index);
                            }, 0);
                        }
                    });
                    grdCompanyRequestList.datagrid('fixDetailRowHeight', index);
                },
                queryParams: {
                    licenseStatusId: 0,
                    IsNewLicense: -1,
                    activityTypeId:-1
                }
            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            grdCompanyRequestList.datagrid('enableFilter', [
                
                {
                    field: 'UserName',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'BrandName',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'CompanyName',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'RequestByUser',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'ManagerMobilePhone',
                    type: 'text',
                    op: textOp,
                }
                


            ]);

        });


        function displayLicenseDetailLicenseOwnerList() {
            
            var state = 1;//نمایش اطلاعات
            var row = grdCompanyRequestList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            
            window.open('/AdminBaraneh/Companies/CompanyRequestEdit.aspx?CompnayLicensingId=' + row.CompanyLicensingId );

        }

        function PrintLic() {
           
            var row = grdCompanyRequestList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            window.open('/Reports/Print/PrintCompanyLicensing.html?companyLicensingGUID=' + row.CompanyLicensingGUID);

        }

    function changeTypeRequest() {

        var row = grdCompanyRequestList.datagrid('getSelected');
        if (row == null) {
            $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
            return;
        }

        $.messager.progress({ title: 'لطفا صبر کنید...' });
        $.messager.confirm('Confirm', 'آیا برای انجام عملیات اطمینان دارید؟', function (r) {
            if (r) {

                $.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                $.ajax({
                    url: '/Companies/API/Companies/CompanyLicensingChangeRequestType',
                    type: 'post',
                    contentType: 'application/json',
                    data: JSON.stringify(row.CompanyLicensingId),
                    success: function (data) {
                        $.messager.progress("close");
                        if (data) {
                            $.messager.alert('پیغام سیستمی', data.Message, 'info');
                            grdCompanyRequestList.datagrid('reload');
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                        $.messager.progress("close")
                        showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    }

                });

                $.messager.progress('close');
            }
        });

    }

        function searchAll() {

            var opts = grdCompanyRequestList.datagrid('options');
            var licenseStatusId = $("#drpLicenseStatus").combobox("getValue");
            var isRenew = $("#drpIsRenew").combobox("getValue");
            var activityTypeId = $("#drpActivityType").combobox("getValue");

            opts.queryParams['licenseStatusId'] = licenseStatusId;
            opts.queryParams['IsNewLicense'] = isRenew;
            opts.queryParams['activityTypeId'] = activityTypeId;
            grdCompanyRequestList.datagrid('reload');

        }
        $(document).ready(function () {
            restrictAccess();
        });
    
</script>
    <!-- -------------- End Of Page Script -------------- -->
</asp:Content>