﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <script src="/Resources/plugins/highCharts-v11.4.6/code/highcharts.js"></script>
    <script src="/Resources/plugins/highCharts-v11.4.6/code/modules/exporting.js"></script>
    <script src="/Resources/plugins/highCharts-v11.4.6/code/modules/export-data.js"></script>
    <script src="/Resources/plugins/highCharts-v11.4.6/code/modules/accessibility.js"></script>
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px; width:100%">
        <!-- <div data-options="region:'north',split:false" title="جستجو" style="height:65px;">-->
        <div data-options="region:'center',title:'نمودار تعداد درخواست پروانه فعالیت در ماه'">

            <table>
                <tr>
                    <td>
                        از سال:
                        <select class="easyui-combobox" id="fromyear" style="width:120px">
                            <option value="0" selected="selected">انتخاب ...</option>
                            <option value="1396">1396</option>
                            <option value="1397">1397</option>
                            <option value="1398">1398</option>
                            <option value="1399">1399</option>
                            <option value="1400">1400</option>
                            <option value="1401">1401</option>
                            <option value="1402">1402</option>
                            <option value="1403">1403</option>

                        </select>
                    </td>
                    <td>
                        از ماه:
                        <select class="easyui-combobox" id="frommonthSelected" style="width:120px">
                            <option value="0" selected="selected">انتخاب ...</option>
                            <option value="1">فروردین</option>
                            <option value="2">اردیبهشت</option>
                            <option value="3">خرداد</option>
                            <option value="4">تیر</option>
                            <option value="5">مرداد</option>
                            <option value="6">شهریور</option>
                            <option value="7">مهر</option>
                            <option value="8">آبان</option>
                            <option value="9">آذر</option>
                            <option value="10">دی</option>
                            <option value="11">بهمن</option>
                            <option value="12">اسفند</option>
                        </select>
                    </td>
                    <td>
                        تا سال:
                        <select class="easyui-combobox" id="toyear" style="width:120px">
                            <option value="0" selected="selected">انتخاب ...</option>
                            <option value="1396">1396</option>
                            <option value="1397">1397</option>
                            <option value="1398">1398</option>
                            <option value="1399">1399</option>
                            <option value="1400">1400</option>
                            <option value="1401">1401</option>
                            <option value="1402">1402</option>
                            <option value="1403">1403</option>

                        </select>
                    </td>
                    <td>
                        تا ماه:
                        <select class="easyui-combobox" id="tomonthSelected" style="width:120px">
                            <option value="0" selected="selected">انتخاب ...</option>
                            <option value="1">فروردین</option>
                            <option value="2">اردیبهشت</option>
                            <option value="3">خرداد</option>
                            <option value="4">تیر</option>
                            <option value="5">مرداد</option>
                            <option value="6">شهریور</option>
                            <option value="7">مهر</option>
                            <option value="8">آبان</option>
                            <option value="9">آذر</option>
                            <option value="10">دی</option>
                            <option value="11">بهمن</option>
                            <option value="12">اسفند</option>
                        </select>
                    </td>
                    <td>
                        نوع پلاک:
                        <select class="easyui-combobox" id="plaqueType" style="width:120px">
                            <option selected="selected" value="1">همه</option>
                            <option value="2">عمومی</option>


                        </select>
                    </td>

                    <td>
                        <a id="btnSearchCahrt" onclick="searchOnDBChart()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">ساخت نمودار</a>

                    </td>
                </tr>
            </table>
            <table style="width: 100%">
                <tr>
                    <td style="width:60%">
                        <div id="container3" style="min-width: 800px; max-width: 100%; height: 500px; margin: 0 auto; direction: ltr;"></div>

                    </td>
                </tr>
            </table>
        </div>

      
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
      


        function searchOnDBChart() {

            var fromyear = $('#fromyear').combobox('getValue');
            var frommonthSelected = $('#frommonthSelected').combobox('getValue');
            var toyear = $('#toyear').combobox('getValue');
            var tomonthSelected = $('#tomonthSelected').combobox('getValue');
            var plate = $('#plaqueType').val();


            if (fromyear == 0 ) {
                $.messager.alert('خطا', 'لطفا سال شروع را مشخص نمایید');
                return;
            }

            if (frommonthSelected == 0) {
                $.messager.alert('خطا', 'لطفا ماه شروع را مشخص نمایید');
                return;
            }

            if (toyear == 0) {
                $.messager.alert('خطا', 'لطفا سال پایان را مشخص نمایید');
                return;
            }

            if (tomonthSelected == 0) {
                $.messager.alert('خطا', 'لطفا ماه پایان را مشخص نمایید');
                return;
            }




            var queryParams = {
                fromYear: fromyear,
                fromMonth: frommonthSelected,
                toYear: toyear,
                toMonth: tomonthSelected,
                plateType: plate
            }


            $.messager.progress();

            $.ajax({
                url: '/CoreServices/API/DashReports/GetCountOfLicensingRequestInMonth',
                type: 'GET',
                data: queryParams,
                success: function (data) {

                    createBarChart(data.rows);
                    $.messager.progress('close');

                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    alert('Error');
                }
            });
        }
        function createBarChart(inputData) {


            var regYear = [];
            var regMonth = [];
            var c1 = [];
            var c2 = [];
            var c3 = [];
            var c4 = [];
            var c5 = [];
            var totalRequest = [];


            for (var i = 0; i < inputData.length; i++) {

                regYear.push(inputData[i]['RegYear']);
                regMonth.push(inputData[i]['RegMonth']);
                c1.push(inputData[i]['C1']);
                c2.push(inputData[i]['C2']);
                c3.push(inputData[i]['C3']);
                c4.push(inputData[i]['C4']);
                c5.push(inputData[i]['C5']);
                totalRequest.push(inputData[i]['TotalRequest']);


            }

            Highcharts.chart('container3', {
                chart: {
                    type: 'column',
                    style: {
                        fontFamily: 'adad'
                    }
                },
                title: {
                    text: 'نمودار تعداد درخواست پروانه فعالیت در ماه'
                },
                subtitle: {
                    // text: 'Source: WorldClimate.com'
                },
                xAxis: {
                    categories: regMonth ,
                    title: {
                        text: 'ماه درخواست ها '
                    },

                labels: {
                    rotation: 90
                }

                },
                yAxis: {
                    min: 0,
                    title: {
                        text: 'تعداد درخواست ها'
                    },
                    chart: {

                        style: {
                            fontFamily: 'Vazir'
                        }
                    },
                },
                tooltip: {

         //        headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
         //        pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
         //        '<td style="padding:0"><b>{point.y}</b></td></tr>',
         //          footerFormat: '</table>',
    formatter: function() {
        var s = '<b>'+ this.x +'</b>';
        var chart = this.points[0].series.chart; //get the chart object
        var categories = chart.xAxis[0].categories; //get the categories array
        var index = 0;
        while(this.x !== categories[index]){index++;} //compute the index of corr y value in each data arrays           
        $.each(chart.series, function(i, series) { //loop through series array
            s += '<br/>'+ series.name +': ' +
                series.data[index].y ;     //use index to get the y value
        });           
        return s;
    },
                    shared: true,
                    useHTML: true
                },
                plotOptions: {
                    column: {
                        pointPadding: 0.2,
                        borderWidth: 0
                    }
                },
                series:
                [

                    {
                        name: 'C1',
                        data: c1

                    },
                    {
                        name: 'C2',
                        data: c2

                    },
                    {
                        name: 'C3',
                        data: c3

                    },
                    {
                        name: 'C4',
                        data: c4

                    },
                    {
                        name: 'C5',
                        data: c5

                    },

                    {
                        name: 'TotalRequest',
                        data: totalRequest

                    }
        ,
                    {
                        name: 'Year',
                        data: regYear,
              showInLegend:false ,
visible:false
                      },

                    {
                        name: 'Month',
                        data: regMonth,
                    showInLegend:false  ,
visible:false
                    }

                ]

            });

        }


        $(document).ready(function () {
            restrictAccess();
        });


    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>