﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <script src="/Resources/plugins/highCharts-v11.4.6/code/highcharts.js"></script>
    <script src="/Resources/plugins/highCharts-v11.4.6/code/modules/exporting.js"></script>
    <script src="/Resources/plugins/highCharts-v11.4.6/code/modules/export-data.js"></script>
    <script src="/Resources/plugins/highCharts-v11.4.6/code/modules/accessibility.js"></script>
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px; width:100%">
        
        <div data-options="region:'center',title:'نمودار تعداد درخواست پروانه اشتغال در روز'">

            <table>
                <tr>
                    <td>
                        از تاریخ:
                        <input id="dpFromDateChart" class="dpTextBox dpTextBox-Invalid" style="width:80px; background-color:antiquewhite;" />
                             
                    </td>
                    <td>
                        تا تاریخ:
                        <input id="dpToDateChart"class="dpTextBox dpTextBox-Invalid" style="width:80px; background-color:antiquewhite;" />
                             
                    </td>
                    <td>
                        <a id="btnSearchCahrt" onclick="searchOnDBChart()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">ساخت نمودار</a>

                    </td>
                </tr>
            </table>
            <table style="width: 100%">
                <tr>
                    <td style="width:60%">
                        <div id="container3" style="min-width: 800px; max-width: 100%; height: 500px; margin: 0 auto; direction: ltr;"></div>

                    </td>
                </tr>
            </table>
        </div>

       
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
       

     
        function searchOnDBChart() {

            var fromdate = $('#dpFromDateChart').dpGetEnValue();
            var todate = $('#dpToDateChart').dpGetEnValue();

            fromDate = $('#dpFromDateChart').dpGetEnValue();
            if (fromDate == '') {
                $.messager.alert('خطا', 'لطفا تاریخ شروع را مشخص نمایید');
                return;
            }

            toDate = $('#dpToDateChart').dpGetEnValue();
            if (toDate == '') {
                $.messager.alert('خطا', 'لطفا تاریخ پایان را مشخص نمایید');
                return;
            }



            var queryParams = {
                fromDate: fromdate,
                toDate: todate
            }

           
            $.messager.progress();

            $.ajax({
                url: '/CoreServices/API/DashReports/GetCountOfDriverLicensingInDates',
                type: 'GET',
                data: queryParams,
                success: function (data) {

                    createBarChart(data.rows);
                    $.messager.progress('close');

                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    alert('Error');
                }
            });
        }
        function createBarChart(inputData) {



            var totalRequest = [];
            var requestDate = [];

            for (var i = 0; i < inputData.length; i++) {

                totalRequest.push(inputData[i]['TotalRequest']);
                requestDate.push(inputData[i]['RequestDate']);

            }

            Highcharts.chart('container3', {
                chart: {
                    type: 'column',
                    style: {
                        fontFamily: 'adad'
                    }
                },
                title: {
                    text: 'نمودار تعداد درخواست پروانه فعالیت در روز'
                },
                subtitle: {
                    // text: 'Source: WorldClimate.com'
                },
                xAxis: {
                    categories: requestDate,
                    title: {
                        text: 'تاریخ درخواست ها '
                    },

                    labels: {
                        rotation: 90
                    }

                },
                yAxis: {
                    min: 0,
                    title: {
                        text: ' تعداد درخواست ها'
                    },
                    chart: {

                        style: {
                            fontFamily: 'Vazir'
                        }
                    },
                },
                tooltip: {
                    headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
                    pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                    '<td style="padding:0"><b>{point.y}</b></td></tr>',
                    footerFormat: '</table>',
                    shared: true,
                    useHTML: true
                },
                plotOptions: {
                    column: {
                        pointPadding: 0.2,
                        borderWidth: 0
                    }
                },
                series:
                [
                    
                    {
                        name: 'TotalRequest',
                        data: totalRequest

                    }

                ]

            });

        }

        $(document).ready(function () {
            restrictAccess();
        });



    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>