﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px">
        <div data-options="region:'center',title:'گزارش وضعیت ثبتی خودروها '">
            <table id="grdVeicleStateList">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'MISPlaque', sortable:'true', width:160">شماره پلاک</th>
                        <th data-options="field:'CreateDate',type:'datebox', sortable:'true', width:160">تاریخ</th>
                        <th data-options="field:'State', sortable:'true', width:60">وضعیت</th>
                    </tr>
                </thead>
            </table>
           
            <div id="gridtoolbarVehicleState" style="padding:2px 5px;">
                تاریخ:<input id="dpCreateDate"class="dpTextBox dpTextBox-Invalid" style="width:100px;background-color:antiquewhite;">
                     <input hidden id="txtCreateDateVal"/>
                <input tabindex="4" id="txtIranPlateNoVehicleState" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                <span>ایران</span>
                <input tabindex="3" id="txtThreePlateNoVehicleState" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">

                <select tabindex="2" id="drpTwoPlateNoVehicleState" class="easyui-combobox" data-options="width:'40px'">
                    <option value="-1" selected="selected"></option>
                    <option value="01">الف</option>
                    <option value="02">ب</option>
                    <option value="04">ت</option>
                    <option value="06">ج</option>
                    <option value="07">چ-ژ</option>
                    <option value="10">د</option>
                    <option value="15">س</option>
                    <option value="17">ص</option>
                    <option value="19">ط</option>
                    <option value="21">ع</option>
                    <option value="24">ق</option>
                    <option value="27">ل</option>
                    <option value="28">م</option>
                    <option value="29">ن</option>
                    <option value="30">و</option>
                    <option value="31">هـ</option>
                    <option value="32">ی</option>
                    <option value="33">D</option>
                    <option value="34">S</option>
                </select>
                <input tabindex="1" type="text" id="txtOnePlateNoVehicleState" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">
                <a onclick="VehicleState_SearchOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو</a>
                <a onclick="VehicleState_ClearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                <a id="btnPrintVehicleState" onclick="printVehicleState()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ</a>
                <a id="btnDeleteCarList" onclick="btnDeleteCarList()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">لیست حذف قطعی خودروها</a>
                <a id="btnPrintDeleteCarList" onclick="printDeleteCarList()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ لیست حذف قطعی ها</a>

                </div>
            </div>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
        $(function () {

            $.ajax({
                url: '/CoreServices/API/Shared/GetDate',
                type: 'GET',
                contentType: 'application/json',
                data: { diffDay: 0 },
                success: function (data) {
                    $('#dpCreateDate').dpGetEnValue();
                },
                error: function (xhr, textStatus, errorThrown) {
                }
            });
        });
        var grdVeicleStateList = $('#grdVeicleStateList');


        $(function () {

            grdVeicleStateList.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: true,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 20,
                pageList: [5, 10, 20, 50, 100, 99999],
                url: '/CoreServices/API/Car/GetVehicleState',
                rownumbers: true,
                sortName: 'CreateDate',
                sortOrder: 'desc',
                isBindOnLoad: false,
                toolbar: '#gridtoolbarVehicleState'

            });
     

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;



        });

        function VehicleState_ClearFilter() {

            $('#txtOnePlateNoVehicleState').textbox('clear');
            $('#txtThreePlateNoVehicleState').textbox('clear');
            $('#txtIranPlateNoVehicleState').textbox('clear');
            $('#drpTwoPlateNoVehicleState').combobox('reset');
            $('#dpCreateDate').val('');

            var opts = grdVeicleStateList.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['plaque'] = '';
            opts.queryParams['createDate'] = '';
            opts.queryParams['isDeleted'] = 0;
            grdVeicleStateList.datagrid('reload', opts.queryParams);

        }
        //لیست خودروهای حذف شده در یک روز
        function btnDeleteCarList() {

            var opts = grdVeicleStateList.datagrid('options');
            opts.isBindOnLoad = true;

            //plaqueValue = getPlateNoDataVehicleState();
            //if (plaqueValue == 'error')
            //    return;

           // var createDate = $('#dpCreateDate').val();
            opts.queryParams['plaque'] = null;
            opts.queryParams['createDate'] = null;
            opts.queryParams['isDeleted'] = 1;

            grdVeicleStateList.datagrid('reload', opts.queryParams);

        }
        function VehicleState_SearchOnDB() {

            var opts = grdVeicleStateList.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNoDataVehicleState();
            if (plaqueValue == 'error')
                return;

            var createDate = $('#dpCreateDate').val();
            opts.queryParams['plaque'] = plaqueValue;
            opts.queryParams['createDate'] = createDate;
            opts.queryParams['isDeleted'] = 0;
            grdVeicleStateList.datagrid('reload', opts.queryParams);

        }
        function getPlateNoDataVehicleState() {
            var onePlateNo = Math.floor($('#txtOnePlateNoVehicleState').val());
            var twoPlateNo = Math.floor($('#drpTwoPlateNoVehicleState').combobox('getValue'));
            var threePlateNo = Math.floor($('#txtThreePlateNoVehicleState').val());
            var iranPlateNo = Math.floor($('#txtIranPlateNoVehicleState').val());

            if (onePlateNo == 0 || twoPlateNo == -1 || threePlateNo == 0 || iranPlateNo == 0) {
                return '';
            }


            if (twoPlateNo.toString().length == 1)
                twoPlateNo = '0' + twoPlateNo.toString();

            var result = '';
            result = onePlateNo.toString() + twoPlateNo.toString() + threePlateNo.toString() + iranPlateNo.toString();
            return result;
        }

        
        function printVehicleState() {

            var plaque = getPlateNoDataVehicleState();
            var createDate = $('#dpCreateDate').val();
            var isDeleted = 0;
        
            var queryParam =
                {
                    plaque: plaque,
                    createDate: createDate,
                    isDeleted: isDeleted
                };

            var opts = grdVeicleStateList.datagrid('options');
            //OrderBy
            queryParam.orderby = opts.finalOrder;
            if (opts.filterRulesString)
                queryParam.filter = opts.filterRulesString;
            var recursiveEncoded = $.param(queryParam);

            window.open('/Reports/Print/PrintVehicleState.html?' + recursiveEncoded);
        }
        function printDeleteCarList() {

            //var plaque = getPlateNoDataVehicleState();
            //var createDate = $('#dpCreateDate').val();
            var isDeleted = 1;

            var queryParam =
                {
                    plaque: "",
                    createDate: "",
                    isDeleted: isDeleted
                };

            var opts = grdVeicleStateList.datagrid('options');
            //OrderBy
            queryParam.orderby = opts.finalOrder;
            if (opts.filterRulesString)
                queryParam.filter = opts.filterRulesString;
            var recursiveEncoded = $.param(queryParam);

            window.open('/Reports/Print/PrintVehicleState.html?' + recursiveEncoded);
        }

        $(document).ready(function () {
            restrictAccess();
        });
    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>