﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div class="easyui-layout" id="mainLayout" style="height:500px;width:100%">

        <div data-options="region:'center',title:'لیست درخواست های ادمین'">
            <table id="grdCarRequestListAdmin">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'VIN', sortable:'true', width:160">VIN</th>
                        <th data-options="field:'MISPlaque', sortable:'true', width:160">شماره پلاک</th>
                        <th data-options="field:'System', sortable:'true', width:160">سیستم</th>
                        <th data-options="field:'style', sortable:'true', width:160">تیپ</th>
                        <th data-options="field:'Color', sortable:'true', width:160">رنگ</th>
                        <th data-options="field:'OwnerName', sortable:'true', width:160">نام مالک</th>
                        <th data-options="field:'OwnerCellPhone', sortable:'true', width:160">شماره تماس</th>
                        <th data-options="field:'UsageName', sortable:'true', width:160">کاربرد</th>
                        <th data-options="field:'Name', sortable:'true', width:160">شرکت مورد تقاضا</th>

                    </tr>
                </thead>
            </table>

            <div id="gridtoolbarCarRequestListAdmin" style="padding:2px 5px;">
                <input id="txtLicenseOwner" class="easyui-textbox" style="width:300px;height:25px " labelWidth="120" data-options="label:'شرکت مورد تقاضا :'">
                <input tabindex="4" id="txtIranPlateNoCarRequestListAdmin" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                <span>ایران</span>
                <input tabindex="3" id="txtThreePlateNoCarRequestListAdmin" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                <select tabindex="2" id="drpTwoPlateNoCarRequestListAdmin" class="easyui-combobox" data-options="width:'40px'">
                    <option value="-1" selected="selected"></option>
                    <option value="01">الف</option>
                    <option value="02">ب</option>
                    <option value="04">ت</option>
                    <option value="06">ج</option>
                    <option value="07">چ-ژ</option>
                    <option value="10">د</option>
                    <option value="15">س</option>
                    <option value="17">ص</option>
                    <option value="19">ط</option>
                    <option value="21">ع</option>
                    <option value="24">ق</option>
                    <option value="27">ل</option>
                    <option value="28">م</option>
                    <option value="29">ن</option>
                    <option value="30">و</option>
                    <option value="31">هـ</option>
                    <option value="32">ی</option>
                    <option value="33">D</option>
                    <option value="34">S</option>

                </select>
                <input tabindex="1" type="text" id="txtOnePlateNoCarRequestListAdmin" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">
                <a id="btnSearchCarRequestListAdmin" onclick="CarRequestListAdmin_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                <a id="btnClearCarRequestListAdmin" onclick="searchCarRequestListAdminOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو/به روز رسانی</a>
                <a href="#" class="easyui-linkbutton" onclick="CarRequestListAdminConfirm(2)" iconCls="">نامشخص ها</a>
                <a href="#" class="easyui-linkbutton" onclick="CarRequestListAdminConfirm(1)" iconCls="">تایید شده ها</a>
                <a href="#" class="easyui-linkbutton" onclick="CarRequestListAdminConfirm(3)" iconCls="">رد شده ها</a>
                نوع چاپ:<select id="drpPrintCarRequestListAdmin" class="easyui-combobox" data-options="width:'180px',panelHeight:'auto',editable:false">
                    <option value="-1" selected="selected"></option>
                    <option value="1">چاپ بر اساس شرکت مورد تقاضا</option>
                    <option value="2">چاپ بر اساس پلاک</option>
                    <option value="3">چاپ نامشخص ها</option>
                    <option value="4">چاپ تایید شده ها</option>
                    <option value="5">چاپ رد شده ها</option>
                    <option value="6">چاپ کلی</option>
                </select>
                <a id="btnPrintCarRequestListAdmin" onclick="printCarRequestListAdmin()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ</a>
            </div>
            </div>


    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>

        var grdCarRequestListAdmin = $('#grdCarRequestListAdmin');



        $(function () {



            grdCarRequestListAdmin.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: false,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [ 15, 50, 100, 99999],
                url: '/CoreServices/API/Request/GetListBySearch',
                rownumbers: true,
                sortName: 'RequestDate',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarCarRequestListAdmin',
                height:  $(window).height() - 160,

                queryParams: {
                    plaqueValue: '',
                    type: '',
                    ownerName:''
                   }


            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;

            grdCarRequestListAdmin.datagrid('enableFilter', [
       {
           field: 'VIN',
           type: 'text',
           op: textOp,
       },
              {
                  field: 'MISPlaque',
                  type: 'text',
                  op: textOp,
              },
               {
                   field: 'System',
                   type: 'text',
                   op: textOp,
               },
                {
                    field: 'style',
                    type: 'text',
                    op: textOp,
                },
                  {
                      field: 'Color',
                      type: 'text',
                      op: textOp,
                  },
                  {
                      field: 'OwnerName',
                      type: 'text',
                      op: textOp,
                  },
                     {
                         field: 'OwnerCellPhone',
                         type: 'text',
                         op: textOp,
                     },
                       {
                           field: 'UsageName',
                           type: 'text',
                           op: textOp,
                       },
                         {
                             field: 'Name',
                             type: 'text',
                             op: textOp,
                         },
            ]);

        });
        function CarRequestListAdminConfirm(type) {
            var opts = grdCarRequestListAdmin.datagrid('options');
            opts.isBindOnLoad = true;
            opts.queryParams['plaqueValue'] = '';
            opts.queryParams['ownerName'] = '';
            opts.queryParams['type'] = type;
            grdCarRequestListAdmin.datagrid('reload');
        }









        function searchCarRequestListAdminOnDB() {

            var opts = grdCarRequestListAdmin.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNoDataCarRequestListAdmin('txtOnePlateNoCarRequestListAdmin', 'drpTwoPlateNoCarRequestListAdmin', 'txtThreePlateNoCarRequestListAdmin', 'txtIranPlateNoCarRequestListAdmin');
            if (plaqueValue == 'error')
                return;
            var ownerName = $('#txtLicenseOwner').textbox('getValue');
            opts.queryParams['plaqueValue'] = plaqueValue;
            opts.queryParams['type'] = '';
            opts.queryParams['ownerName'] = ownerName;


            grdCarRequestListAdmin.datagrid('reload', opts.queryParams);

        }
        function CarRequestListAdmin_clearFilter() {

            $('#txtOnePlateNoCarRequestListAdmin').textbox('clear');
            $('#txtThreePlateNoCarRequestListAdmin').textbox('clear');
            $('#txtIranPlateNoCarRequestListAdmin').textbox('clear');
            $('#drpTwoPlateNoCarRequestListAdmin').combobox('reset');
            $('#txtLicenseOwner').textbox('clear');
            $('#drpPrintCarRequestListAdmin').combobox('clear');

            var opts = grdCarRequestListAdmin.datagrid('options');
            opts.isBindOnLoad = true;

            //plaqueValue = getPlateNoDataCarRequestListAdmin('txtOnePlateNoCarRequestListAdmin', 'drpTwoPlateNoCarRequestListAdmin', 'txtThreePlateNoCarRequestListAdmin', 'txtIranPlateNoCarRequestListAdmin');
            //if (plaqueValue == 'error')
            //    return;

            opts.queryParams['plaqueValue'] = '';
            opts.queryParams['type'] = '';
            grdCarRequestListAdmin.datagrid('reload', opts.queryParams);

        }
       
        function getPlateNoDataCarRequestListAdmin(txtOnePlateNoId, drpTwoPlateNoId, txtThreePlateNoId, txtIranPlateNoId) {

            var onePlateNo = Math.floor($('#' + txtOnePlateNoId).val());
            var twoPlateNo = Math.floor($('#' + drpTwoPlateNoId).combobox('getValue'));
            var threePlateNo = Math.floor($('#' + txtThreePlateNoId).val());
            var iranPlateNo = Math.floor($('#' + txtIranPlateNoId).val());

            if (onePlateNo == 0 && twoPlateNo == -1 && threePlateNo == 0 && iranPlateNo == 0) {
                return '';
            }

            var isValidValue = true;

            if (onePlateNo == 0 || (onePlateNo < 10 || onePlateNo > 99))
                isValidValue = false;

            if (twoPlateNo == -1)
                isValidValue = false;

            if (threePlateNo == 0 || (threePlateNo < 10 || threePlateNo > 999))
                isValidValue = false;

            if (iranPlateNo < 10 || iranPlateNo > 99)
                isValidValue = false;

            if (isValidValue == false) {
                $.messager.alert('خطا', 'شماره پلاک خطا دارد');
                return 'error';
            }

            if (twoPlateNo.toString().length == 1)
                twoPlateNo = '0' + twoPlateNo.toString();

            var plaqueValue = onePlateNo.toString() + twoPlateNo.toString() + threePlateNo.toString() + iranPlateNo.toString();

            return plaqueValue;

        }
        function printCarRequestListAdmin() {
            var queryParamOwnerName = '';
            var queryParamPlate = '';
            var queryParamSelected = 0;
            var txtLicenseOwner = $('#txtLicenseOwner').textbox('getValue');
            var selectType = parseInt($('#drpPrintCarRequestListAdmin').combobox('getValue'));
            if (selectType == null || selectType < 0 || selectType == NaN) {
                $.messager.alert('اخطار', 'نوع چاپ را انتخاب نمایید');
                return;
            }
            switch (selectType) {
                case 1://چاپ بر اساس شرکت
                    if (txtLicenseOwner == '') {
                        $.messager.alert('اخطار', 'شرکت مورد تقاضا را مشخص نمایید');
                        return;
                    }
                    queryParamOwnerName = txtLicenseOwner;
                    break;
                case 2://بر اساس پلاک
                    var plaque = getPlateNoDataCarRequestListAdmin();
                    if (plaque == '') {
                        $.messager.alert('اخطار', 'پلاک را وارد نمایید');
                        return;
                    }
                    queryParamPlate = plaque;
                    break;
                case 3://چاپ نامشخص ها
                    queryParamSelected = 2;
                    break;
                case 4://چاپ تایید شده ها
                    queryParamSelected = 1;
                    break;
                case 5://چاپ رد شده ها
                    queryParamSelected = 3;
                    break;
                case 6://چاپ کلی
                    queryParamSelected =0 ;
                    break;
            }
            var queryParam = {
                plaqueValue: queryParamPlate,
                type: queryParamSelected,
                ownerName: queryParamOwnerName
            };
            var opts = grdCarRequestListAdmin.datagrid('options');
            //OrderBy
            queryParam.orderby = opts.finalOrder;
            if (opts.filterRulesString)
                queryParam.filter = opts.filterRulesString;
            var recursiveEncoded = $.param(queryParam);

            window.open('/Reports/Print/PrintCarRequestListAdmin.html?' + recursiveEncoded);
        }


        $(document).ready(function () {
            restrictAccess();
        });

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>