﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div class="easyui-layout" id="mainLayout" style="height:500px;width:100%">

        <div data-options="region:'center',title:'لیست درخواست'">

            <table id="grdCarRequestList">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'VIN', sortable:'true', width:160">VIN</th>
                        <th data-options="field:'MISPlaque', sortable:'true', width:160">شماره پلاک</th>
                        <th data-options="field:'System', sortable:'true', width:160">سیستم</th>
                        <th data-options="field:'style', sortable:'true', width:160">تیپ</th>
                        <th data-options="field:'Color', sortable:'true', width:160">رنگ</th>
                        <th data-options="field:'OwnerName', sortable:'true', width:160">نام مالک</th>
                        <th data-options="field:'OwnerCellPhone', sortable:'true', width:160">شماره تماس</th>
                        <th data-options="field:'UsageName', sortable:'true', width:160">کاربرد</th>


                    </tr>
                </thead>
            </table>
            <div id="gridtoolbarCarRequestList" style="padding:2px 5px;">
                <a href="#" class="easyui-linkbutton" onclick="CarRequestListReception(1)" iconCls="icon-ok">پذیرش</a>
                <a href="#" class="easyui-linkbutton" onclick="CarRequestListReception(2)" iconCls="icon-cancel">عدم پذیرش</a>
                <!--  <input id="txtCode" class="easyui-textbox" style="width:150px;height:25px " data-options="label:'نام شرکت:'">-->
                <input tabindex="4" id="txtIranPlateNoCarRequestList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                <span>ایران</span>
                <input tabindex="3" id="txtThreePlateNoCarRequestList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                <select tabindex="2" id="drpTwoPlateNoCarRequestList" class="easyui-combobox" data-options="width:'40px'">
                    <option value="-1" selected="selected"></option>
                    <option value="01">الف</option>
                    <option value="02">ب</option>
                    <option value="04">ت</option>
                    <option value="06">ج</option>
                    <option value="07">چ-ژ</option>
                    <option value="10">د</option>
                    <option value="15">س</option>
                    <option value="17">ص</option>
                    <option value="19">ط</option>
                    <option value="21">ع</option>
                    <option value="24">ق</option>
                    <option value="27">ل</option>
                    <option value="28">م</option>
                    <option value="29">ن</option>
                    <option value="30">و</option>
                    <option value="31">هـ</option>
                    <option value="32">ی</option>
                    <option value="33">D</option>
                    <option value="34">S</option>

                </select>
                <input tabindex="1" type="text" id="txtOnePlateNoCarRequestList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">
                <a id="btnSearchCarRequestList" onclick="searchCarRequestListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو/به روز رسانی</a>
                <a id="btnClearCarRequestList" onclick="CarRequestList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>

            
            </div>


        </div>
    </div>






    <div id="winCarEdit" title="Basic Window">
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>

        var grdCarRequestList = $('#grdCarRequestList');
        var winCarEdit = $('#winCarEdit');

        function toExcel() {
            $('#grdCarRequestList').datagrid('toExcel', 'dg.xls');
        }

        $(function () {

            winCarEdit.window({
                width: '1060',
                height: '500',

                modal: true,
                title: "فرم اطلاعات خودروها",
                closed:true
            })

            grdCarRequestList.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: false,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [ 15, 50, 100, 99999],
                url: '/CoreServices/API/Request/GetList',
                rownumbers: true,
                sortName: 'RequestId',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarCarRequestList',
                height:  $(window).height() - 160,
                
                queryParams: { plaqueValue:''}
                

            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;

            grdCarRequestList.datagrid('enableFilter', [
       {
           field: 'VIN',
           type: 'text',
           op: textOp,
       },
              {
                  field: 'MISPlaque',
                  type: 'text',
                  op: textOp,
              },
               {
                   field: 'System',
                   type: 'text',
                   op: textOp,
               },
                {
                    field: 'style',
                    type: 'text',
                    op: textOp,
                },
                  {
                      field: 'Color',
                      type: 'text',
                      op: textOp,
                  },
                  {
                      field: 'OwnerName',
                      type: 'text',
                      op: textOp,
                  },
                  
                     {
                         field: 'OwnerCellPhone',
                         type: 'text',
                         op: textOp,
                     },
                       {
                           field: 'UsageName',
                           type: 'text',
                           op: textOp,
                       },
            ]);

        });


        function openEditCarsWindow(url) {
            winCarEdit.window('open');
            winCarEdit.find('#iframeCarEdit').remove();
            var iframeEdit = $('<iframe id="iframeCarEdit" frameborder=0 style="width:99%" />')
            iframeEdit.appendTo(winCarEdit);
            iframeEdit.height(450);
            iframeEdit.attr('src', url)
        }

        function closeIframeEdit(isSuccess, message) {
            //winCarEdit.window('close');

            //if (isSuccess) {
            //    $.messager.show({
            //        title: 'پیغام',
            //        msg: message,
            //        showType: 'show',
            //        style: {
            //            right: '',
            //            //top: document.body.scrollTop + document.documentElement.scrollTop + 100,
            //            bottom: ''
            //        }

            //    });
            grdCarRequestList.datagrid('reload');

            //}

        }

        function CarRequestListReception(type) {
            var row = grdCarRequestList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            var existRows = grdCarRequestList.datagrid('getSelections');//انتخاب شده ها
            var requestSelectedIds = [];
            for (var i = 0; i < existRows.length; i++) {
                requestSelectedIds.push(existRows[i].RequestId)
           
            }
            var existLicenseOwnerIds = grdCarRequestList.datagrid('getSelections');//آی دی شرکت های انتخابی
            var requestSLicenseOwnerIds = [];
            for (var i = 0; i < existRows.length; i++) {
                requestSLicenseOwnerIds.push(existRows[i].LicenseOwnerId)
            }
     
            $.messager.confirm('Confirm', 'آیا برای ادامه عملیات اطمینان دارید؟', function (r) {
                if (r) {

                    $.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                    $.ajax({
                        url: '/CoreServices/API/Request/RequestReception',
                        type: 'GET',
                        contentType: 'application/json',
                        data: {
                           // vehicleId: row.VehicleId,
                           // licenseOwnerId: row.LicenseOwnerId,
                            type: type,
                            selectedRquests: requestSelectedIds,
                            licenseOwnerIds: requestSLicenseOwnerIds
                        },
                        async: false,
                        success: function (data) {
                   

                            if (data.IsSuccessful == true) {
                                searchCarRequestListOnDB();
                                $.messager.alert('پیام سیستمی', data.Message,"info");
                            }
                            else {
                                $.messager.alert('Warning', data.Message);
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        }
                    });

                    $.messager.progress('close');
                }
            });



        }
    
        function searchCarRequestListOnDB() {

            var opts = grdCarRequestList.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNoDataCarRequestlist('txtOnePlateNoCarRequestList', 'drpTwoPlateNoCarRequestList', 'txtThreePlateNoCarRequestList', 'txtIranPlateNoCarRequestList');
            if (plaqueValue == 'error')
                return;

            opts.queryParams['plaqueValue'] = plaqueValue;
            grdCarRequestList.datagrid('reload', opts.queryParams);

        }
        function CarRequestList_clearFilter() {

            $('#txtOnePlateNoCarRequestList').textbox('clear');
            $('#txtThreePlateNoCarRequestList').textbox('clear');
            $('#txtIranPlateNoCarRequestList').textbox('clear');
            $('#drpTwoPlateNoCarRequestList').combobox('reset');
            //$('#drpTwoPlateNo').combobox('unselect', value);
            
            var opts = grdCarRequestList.datagrid('options');
            opts.isBindOnLoad = true;

      

            opts.queryParams['plaqueValue'] = '';
            grdCarRequestList.datagrid('reload', opts.queryParams);

        }
        function getPlateNoDataCarRequestlist(txtOnePlateNoId, drpTwoPlateNoId, txtThreePlateNoId, txtIranPlateNoId) {

            var onePlateNo = Math.floor($('#' + txtOnePlateNoId).val());
            var twoPlateNo = Math.floor($('#' + drpTwoPlateNoId).combobox('getValue'));
            var threePlateNo = Math.floor($('#' + txtThreePlateNoId).val());
            var iranPlateNo = Math.floor($('#' + txtIranPlateNoId).val());

            if (onePlateNo == 0 && twoPlateNo == -1 && threePlateNo == 0 && iranPlateNo == 0) {
                return '';
            }

            var isValidValue = true;

            if (onePlateNo == 0 || (onePlateNo < 10 || onePlateNo > 99))
                isValidValue = false;

            if (twoPlateNo == -1)
                isValidValue = false;

            if (threePlateNo == 0 || (threePlateNo < 10 || threePlateNo > 999))
                isValidValue = false;

            if (iranPlateNo < 10 || iranPlateNo > 99)
                isValidValue = false;

            if (isValidValue == false) {
                $.messager.alert('خطا', 'شماره پلاک خطا دارد');
                return 'error';
            }

            if (twoPlateNo.toString().length == 1)
                twoPlateNo = '0' + twoPlateNo.toString();

            var plaqueValue = onePlateNo.toString() + twoPlateNo.toString() + threePlateNo.toString() + iranPlateNo.toString();

            return plaqueValue;

        }

        $(document).ready(function () {
            restrictAccess();
        });

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>