﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div  class="easyui-layout" id="mainLayout" style="height:500px;width:100%">
        <div data-options="region:'center',title:'لیست ناوگان'">
            <table id="grdCarList">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'VIN', sortable:'true', width:160">VIN</th>
                        <th data-options="field:'MISPlaque', sortable:'true', width:160">شماره پلاک</th>
                        <th data-options="field:'System', sortable:'true', width:160">سیستم</th>
                        <th data-options="field:'style', sortable:'true', width:160">تیپ</th>
                        <th data-options="field:'Color', sortable:'true', width:160">رنگ</th>
                        <th data-options="field:'OwnerName', sortable:'true', width:160">نام مالک</th>
                        <th data-options="field:'OwnerCellPhone', sortable:'true', width:160">شماره تماس</th>
                        <th data-options="field:'UsageName', sortable:'true', width:160">کاربرد</th>
                        <th data-options="field:'LicensingStatusTitle', sortable:'true', width:200">وضعیت پروانه</th>

                    </tr>
                </thead>
            </table>
            <div id="gridtoolbarCarList" style="padding:2px 5px;">
                <div style="padding:2px 5px;">
                    <a href="#" class="easyui-linkbutton" onclick="displayVehicleCarList()" iconCls="icon-display">نمایش</a>
                    <a href="#" class="easyui-linkbutton" onclick="newVehicleItemCarList()" iconCls="icon-add">جدید</a>
                    <a href="#" class="easyui-linkbutton" onclick="deleteVehicleItemCarList()" iconCls="icon-cancel">حذف</a>
                    <a href="#" class="easyui-linkbutton" onclick="requestDisplacementCarList()" iconCls="">درخواست جابه جایی</a>
                    <a href="#" class="easyui-linkbutton" onclick="licensing()" iconCls="">صدور پروانه</a>
                    <!--  <input id="txtCode" class="easyui-textbox" style="width:150px;height:25px " data-options="label:'نام شرکت:'">-->
                    <input tabindex="4" id="txtIranPlateNoCarList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                    <span>ایران</span>
                    <input tabindex="3" id="txtThreePlateNoCarList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                    <select tabindex="2" id="drpTwoPlateNoCarList" class="easyui-combobox" data-options="width:'40px'">
                        <option value="-1" selected="selected"></option>
                        <option value="01">الف</option>
                        <option value="02">ب</option>
                        <option value="04">ت</option>
                        <option value="06">ج</option>
                        <option value="07">چ-ژ</option>
                        <option value="10">د</option>
                        <option value="15">س</option>
                        <option value="17">ص</option>
                        <option value="19">ط</option>
                        <option value="21">ع</option>
                        <option value="24">ق</option>
                        <option value="27">ل</option>
                        <option value="28">م</option>
                        <option value="29">ن</option>
                        <option value="30">و</option>
                        <option value="31">هـ</option>
                        <option value="32">ی</option>
                        <option value="33">D</option>
                        <option value="34">S</option>

                    </select>
                    <input tabindex="1" type="text" id="txtOnePlateNoCarList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">
                    <a onclick="searchCarListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی تمام ناوگان</a>
                    <a onclick="CarList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                    <a onclick="showDataCarList(1)" class="easyui-linkbutton" data-options="region:'center',iconCls:''">نمایش درخواست های حذف</a>
                    <a onclick="showDataCarList(2)" class="easyui-linkbutton" data-options="region:'center',iconCls:''">نمایش درخواست های جابجایی</a>
                    <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
                </div>

                </div>

            </div>
    </div>
    <div id="dlgCarList" class="easyui-dialog" style="width:420px;height:220px;padding:10px 20px"
         closed="true">
        <form id="frmEdit" method="post" novalidate>

            <table width="100%">
                <tr>
                    <td style="width:15%; text-align:left;">
                        <label>نام شرکت:</label>
                    </td>

                    <td>
                        <input id="drpLicenseOwner" class="easyui-combogrid" data-options="">
                    </td>
                </tr>
            </table>
        </form>
        <a href="javascript:void(0)" class="easyui-linkbutton c6" style="width:90px" iconcls="icon-ok" onclick="confirm()">تایید</a>
        <a href="javascript:void(0)" class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript: $('#dlgCarList').dialog('close')" style="width:90px">لغو</a>
    </div>




    <div id="winCarEdit" title="Basic Window"> </div>
        <div id="winLicensing" title="Basic Window">
        </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>

        var grdCarList = $('#grdCarList');
        var winCarEdit = $('#winCarEdit');
        var winLicensing = $('#winLicensing');
        var drpLicenseOwner = $('#drpLicenseOwner');
       
        function toExcel() {
            $('#grdCarList').datagrid('toExcel', 'dg.xls');
        }

        $(function () {

            winCarEdit.window({
                width: '1060',
                height: '500',

                modal: true,
                title: "فرم اطلاعات خودروها",
                closed:true
            })

            winLicensing.window({
                width: '1060',
                height: '400',

                modal: true,
                title: "فرم صدور پروانه",
                closed: true
            })
        

            grdCarList.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: true,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [ 15, 50, 100, 99999],
                url: '/CoreServices/API/Car/GetList',
                rownumbers: true,
                sortName: 'VehicleId',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarCarList',
                height:  $(window).height() - 160,
                
                queryParams: {
                    plaqueValue: '',
                    type:0
                }
                

            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;

            grdCarList.datagrid('enableFilter', [
       {
           field: 'VIN',
           type: 'text',
           op: textOp,
       },
              {
                  field: 'MISPlaque',
                  type: 'text',
                  op: textOp,
              },
               {
                   field: 'System',
                   type: 'text',
                   op: textOp,
               },
                {
                    field: 'style',
                    type: 'text',
                    op: textOp,
                },
                  {
                      field: 'Color',
                      type: 'text',
                      op: textOp,
                  },
                  {
                      field: 'OwnerName',
                      type: 'text',
                      op: textOp,
                  },
                  
                  {
                      field: 'UsageName',
                      type: 'text',
                      op: textOp,
                      },
                         {
                             field: 'OwnerCellPhone',
                             type: 'text',
                             op: textOp,
                         }
            ]);

        });

        function newVehicleItemCarList() {
          
          
            $.ajax({
                url: '/CoreServices/API/Car/CheckIsAllowToAdd',
                type: 'GET',
                contentType: 'application/json',
                data: {
                },
                success: function (data) {
                    if (data.ReadyToAdd == false) {
                        
                        $.messager.alert('پیغام سیستمی', data.Message, 'info');

                    }
                    else {
                        openEditCarsWindow('/OldBarane/Cars/CarEdit.html?v=8');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                   

                }
            });


            
        }
        function openEditCarsWindow(url) {
            winCarEdit.window('open');
            winCarEdit.find('#iframeCarEdit').remove();
            var iframeEdit = $('<iframe id="iframeCarEdit" frameborder=0 style="width:99%" />')
            iframeEdit.appendTo(winCarEdit);
            iframeEdit.height(450);
            iframeEdit.attr('src', url)
        }
        function closeIframeEdit(isSuccess, message) {
            winCarEdit.window('close');

            if (isSuccess) {
                $.messager.show({
                    title: 'پیغام',
                    msg: message,
                    showType: 'show',
                    style: {
                        right: '',
                        //top: document.body.scrollTop + document.documentElement.scrollTop + 100,
                        bottom: ''
                    }

                });
                grdCarList.datagrid('reload');

            }

        }

        function deleteVehicleItemCarList() {

            

            var row = grdCarList.datagrid('getSelected');

            

            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                if (r) {

                    $.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                    $.ajax({
                        url: '/CoreServices/API/Car/RequestForDelete',
                        type: 'GET',
                        contentType: 'application/json',
                        data: { vehicleId: row.VehicleId },
                        async: false,
                        success: function (data) {

                            if (data.IsSuccessful == true) {

                                $.messager.alert('پیام سیستمی', data.Message,"info");
                            }
                            else {
                                $.messager.alert('Warning', data.Message);
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        }
                    });

                    $.messager.progress('close');
                }
            });



        }
 
        function searchCarListOnDB() {

            var opts = grdCarList.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error')
                return;

            opts.queryParams['plaqueValue'] = plaqueValue;
            opts.queryParams['type'] = 0;
            grdCarList.datagrid('reload', opts.queryParams);

        }
        function showDataCarList(type) {

            var opts = grdCarList.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error')
                return;

            opts.queryParams['plaqueValue'] = plaqueValue;
            opts.queryParams['type'] = type;
            grdCarList.datagrid('reload', opts.queryParams);

        }
        function CarList_clearFilter() {

            $('#txtOnePlateNoCarList').textbox('clear');
            $('#txtThreePlateNoCarList').textbox('clear');
            $('#txtIranPlateNoCarList').textbox('clear');
            $('#drpTwoPlateNoCarList').combobox('reset');
            //$('#drpTwoPlateNo').combobox('unselect', value);
            
            var opts = grdCarList.datagrid('options');
            opts.isBindOnLoad = true;

      

            opts.queryParams['plaqueValue'] = '';
            opts.queryParams['type'] = 0;
            grdCarList.datagrid('reload', opts.queryParams);

        }
        
        var licenseOwnerIdInSelectGrid = 0;
        //درخواست جابه جایی توسط کاربر 
        function requestDisplacementCarList()
        {
            var row = grdCarList.datagrid('getSelected');
            licenseOwnerIdInSelectGrid = row.LicenseOwnerId;//شرکت انتخاب شده از قبل در گیرید برای چک کردن ظرفیت
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            var requestForLicenseOwnerIdChange = row.RequestForLicenseOwnerIdChange;
            if (requestForLicenseOwnerIdChange == null) {
                requestForLicenseOwnerIdChange = 0;
            }
            var LicenseOwnerId = row.LicenseOwnerId;
            //$('#drplicenseOwner').combogrid('setValue', row.LicenseOwnerId);
            $('#drpLicenseOwner').combogrid({
                url: '/CoreServices/API/LicenseOwner/GetComboByLicenseOwnerId',
                panelWidth: 400,
                idField: 'LicenseOwnerId',
                textField: 'Name',
                method: 'get',
                mode: 'remote',
                value:row.LicenseOwnerId,
                columns: [[
                    { field: 'Name', title: 'نام شرکت', width: 200 },
                     { field: 'BrandName', title: 'برند', width: 100 },
                    { field: 'capacity', title: 'ظرفیت', width: 60 },
                    { field: 'ManagerName', title: 'نام مدیر عامل', width: 100 },
                    { field: 'Address', title: 'آدرس', width: 250 },
                    { field: 'Phone', title: 'تلفن', width: 150 }
                ]],
                width: '300px',
                labelWidth: '140px',
                tipPosition: 'left',
                queryParams: {
                    q: '',
                    requestForLicenseOwnerIdChange: requestForLicenseOwnerIdChange
                }

            });
            $('#dlgCarList').dialog('open').dialog('center').dialog('setTitle', 'انتقال شرکت');
          
        }
        function confirm()
        {
            var selectLicenseownerId = $('#drpLicenseOwner').combobox('getValue');
            if (selectLicenseownerId=="") {
                $.messager.alert('Warning', 'لطفا شرکت مورد نظر را انتخاب نمایید');
                return;
            }
            var row = grdCarList.datagrid('getSelected');

            $.messager.confirm('Confirm', 'آیا برای انتقال شرکت اطمینان دارید؟', function (r) {
                if (r) {

                    $.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                    $.ajax({
                        url: '/CoreServices/API/Car/RequestDisplacement',
                        type: 'GET',
                        contentType: 'application/json',
                        data: {
                            licenseOwnerId: selectLicenseownerId,
                            vehicleIds: row.VehicleId,
                            isAdmin: 0,
                            risapproveRequestsIsAdmin: 0,
                            licenseOwnerIdInSelectGrid: licenseOwnerIdInSelectGrid
                            
                           
                        },
                        async: false,
                        success: function (data) {

                            if (data.IsSuccessful == true) {
                                $('#dlgCarList').dialog('close');
                                $.messager.alert('پیام سیستمی', data.Message, "info");
                            }
                            else {
                                $.messager.alert('Warning', data.Message);
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        }
                    });

                    $.messager.progress('close');
                }
            });
        }
        function displayVehicleCarList() {

            var row = grdCarList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            openEditCarsWindow('/Cars/CarEdit.html?vehicleId=' + row['VehicleId']);

        }
        //دکمه صدور پروانه
        function licensing() {

            var row = grdCarList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            //استعلام بدهی
            //$.ajax({
            //    url: '/CoreServices/API/ApiEsp/...',
            //    type: 'GET',
            //    contentType: 'application/json',
            //    data: {
            //        PlateNo: row.PlateNo,
            //        Vin: row.VIN,
            //    },
            //    async: false,
            //    success: function (data) {

            //        if (data.IsSuccessful == true) {//اگر بدهی نداشت
            //            openEditLicensingWindow('/Baraneh/LicensingEdit.html?vehicleId=' + row['VehicleId'] + '&licensingId=' + row['LicensingId']);
            //            //$.messager.alert('پیام سیستمی', data.Message, "info");
            //        }
            //        else {
            //            $.messager.alert('اخطار', 'خودروی مورد نظر در سامانه تهران من دارای بدهی میباشد لذا صدور پروانه فعالیت امکان پذیر نیست');
            //            //$.messager.alert('Warning', data.Message);
            //        }
            //    },
            //    error: function (xhr, textStatus, errorThrown) {
            //        showAjaxErrorMessage(xhr, textStatus, errorThrown);
            //    }
            //});
            //openEditLicensingWindow('/Baraneh/LicensingEdit.html?vehicleId=' + row['VehicleId']);
            openEditLicensingWindow('/AdminBaraneh/Baraneh/LicensingEdit.aspx?vehicleId=' + row['VehicleId']);
        }
        function openEditLicensingWindow(url) {
            winLicensing.window('open');
            winLicensing.find('#iframeLicensingEdit').remove();
            var iframeEdit = $('<iframe id="iframeLicensingEdit" frameborder=0 style="width:99%" />')
            iframeEdit.appendTo(winLicensing);
            iframeEdit.height(300);
            iframeEdit.attr('src', url)
        }


        $(document).ready(function () {
            restrictAccess();
        });

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>