﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px;width:100%">
        <div data-options="region:'center',title:'لیست ناوگان و پروانه های صادر شده'">
            <table id="grdCancelRequestList">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'LicensingId'" hidden="hidden"></th>
                        <th data-options="field:'VIN', sortable:'true', width:160">VIN</th>
                        <th data-options="field:'MISPlaque', sortable:'true', width:160">شماره پلاک</th>
                        <th data-options="field:'LicensingNumber', sortable:'true', width:160">شماره پروانه</th>
                        <th data-options="field:'OwnerName', sortable:'true', width:160">نام مالک</th>
                        <th data-options="field:'OwnerCellPhone', sortable:'true', width:160">شماره تماس</th>
                        <th data-options="field:'ExpireDateRequestByUser', sortable:'true', width:160">تاریخ درخواست ابطال  </th>
                        <th data-options="field:'IsExpired', sortable:'true', width:160" formatter="isExpiredFormat">وضعیت درخواست  </th>
                    </tr>
                </thead>
            </table>
            <div id="gridtoolbarLicensingCarList" style="padding:2px 5px;">
                <div style="padding:2px 5px;">
                    <a href="#" class="easyui-linkbutton" onclick="getAllCancellRequest()" iconCls="icon-ok">بروز رسانی درخواستها از تهران من</a>
                    <a href="#" class="easyui-linkbutton" onclick="confirmCancel()" iconCls="icon-ok"> تایید ابطال پروانه</a>
                    <a href="#" class="easyui-linkbutton" onclick="ignoreCancelLicensing()" iconCls="icon-cancel"> عدم تایید ابطال پروانه</a>
                    <!--<a href="#" class="easyui-linkbutton" onclick="confirm(2)" iconCls="">تایید</a>
                    <a href="#" class="easyui-linkbutton" onclick="confirm(3)" iconCls="">عدم تایید</a>-->
                    <input tabindex="4" id="txtIranPlateNoCarList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                    <span>ایران</span>
                    <input tabindex="3" id="txtThreePlateNoCarList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                    <select tabindex="2" id="drpTwoPlateNoCarList" class="easyui-combobox" data-options="width:'40px'">
                        <option value="-1" selected="selected"></option>
                        <option value="01">الف</option>
                        <option value="02">ب</option>
                        <option value="04">ت</option>
                        <option value="06">ج</option>
                        <option value="07">چ-ژ</option>
                        <option value="10">د</option>
                        <option value="15">س</option>
                        <option value="17">ص</option>
                        <option value="19">ط</option>
                        <option value="21">ع</option>
                        <option value="24">ق</option>
                        <option value="27">ل</option>
                        <option value="28">م</option>
                        <option value="29">ن</option>
                        <option value="30">و</option>
                        <option value="31">هـ</option>
                        <option value="32">ی</option>
                        <option value="33">D</option>
                        <option value="34">S</option>
                    </select>
                    <input tabindex="1" type="text" id="txtOnePlateNoCarList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">
                    <span style="display: inline-block;width:50px;"></span>
                    <a onclick="searchListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                    <a onclick="clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                    <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
                </div>
            </div>
        </div>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
        var grdCancelRequestList = $('#grdCancelRequestList');

        $(document).ready(function () {
            initForm();
        });


        function isExpiredFormat(val, row) {
            if (val) {
                return '<input type="checkbox" checked />';
            } else {
                return '<input type="checkbox"  />';

            }
        }
        function clearFilter() {

            $('#txtOnePlateNoCarList').textbox('clear');
            $('#txtThreePlateNoCarList').textbox('clear');
            $('#txtIranPlateNoCarList').textbox('clear');
            $('#drpTwoPlateNoCarList').combobox('reset');
            //$('#drpTwoPlateNo').combobox('unselect', value);

            var opts = grdCancelRequestList.datagrid('options');
            opts.isBindOnLoad = true;
rn;

            opts.queryParams['plateNo'] = ''; 
            grdCancelRequestList.datagrid('reload', opts.queryParams);

        }

        var ignoreCancelLicensing = () => {
            var row = grdCancelRequestList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            $.messager.confirm('Confirm', 'برای عدم تایید ابطال اطمینان دارید ؟', function (r) {
                if (r) {

                    $.ajax({
                        url: '/CoreServices/API/Licensing/IgnoreCancelLicensing',
                        type: 'Post',
                        contentType: 'application/json',
                        data: JSON.stringify(row.LicensingId),
                        success: function (data) {
                            $.messager.progress('close');
                            if (data.IsSuccessful == true) {
                                $.messager.alert('پیام سیستم', data.Message, 'info');
                                grdCancelRequestList.datagrid('reload');
                            }
                            else {
                                $.messager.alert('Warning', data.Message, 'error');
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                            $.messager.progress('close');
                        }
                    });
                }
            });

        }



        var confirmCancel = () => {

            var row = grdCancelRequestList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            $.messager.confirm('Confirm', 'برای تایید ابطال اطمینان دارید ؟', function (r) {
                if (r) {
                    $.messager.progress({ title: 'لطفا صبر کنید...' });

                    $.ajax({
                        url: '/CoreServices/API/Licensing/ConfirmCancelLicensing',
                        type: 'Post',
                        contentType: 'application/json',
                        data: JSON.stringify(row.LicensingId),
                        success: function (data)
                        {
                            $.messager.progress('close');
                            if (data.IsSuccessful == true)
                            { 
                                $.messager.alert('پیام سیستم', data.Message, 'info'); 
                                grdCancelRequestList.datagrid('reload');
                            }
                            else
                            { 
                                $.messager.alert('Warning', data.Message, 'error');
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            $.messager.progress('close');
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        }
                    });
                }
            });
        }


        function searchListOnDB() {

            var opts = grdCancelRequestList.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error')
                return;
             
            opts.queryParams['plateNo'] = plaqueValue; 
            grdCancelRequestList.datagrid('reload', opts.queryParams);

        }

        function initForm() {
            grdCancelRequestList.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: false,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/Licensing/GetCancelLicensingList',
                rownumbers: true,
                sortName: 'LicensingId',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarLicensingCarList',
                height: $(window).height() - 160,

                queryParams: {
                    plateNo: '',
                }
            });
        }


        function toExcel() {
            $('#grdCancelRequestList').datagrid('toExcel', 'dg.xls');
        }

        var getAllCancellRequest = () =>
        {
            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/CoreServices/API/ApiEsp/SyncAllModifyLicenseList',
                type: 'get',
                contentType: 'application/json', 
                success: function (data)
                {
                    $.messager.progress('close');
                    if (data.IsSuccessful == true)
                    {
                        $.messager.alert('پیام سیستم', data.Message, 'info');
                        grdCancelRequestList.datagrid('reload');
                    }
                    else
                    {
                        $.messager.alert('Warning', data.Message, 'error');
                    }
                },
                error: function (xhr, textStatus, errorThrown)
                {
                    $.messager.progress('close');
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                }
            });


            

        }
      

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>