﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px">
        <div data-options="region:'center',title:'لیست درصد های تخفیف'">
            <table id="grdWhiteList">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'MISPlate', sortable:'true', width:160">شماره پلاک</th>
                        <th data-options="field:'VoucherDate',type:'datebox', sortable:'true', width:160">تاریخ حمل</th>
                        <th data-options="field:'DiscountPercent', sortable:'true', width:60,type:'integer'">درصد تخفیف</th>
                        <th data-options="field:'LicensingId', sortable:'true', width:100">کد فعالیت</th>
                        <th data-options="field:'LicenseStatusTitle', sortable:'true', width:100">وضعیت پروانه</th>
                        <th data-options="field:'CarCategoryTitle', sortable:'true', width:100">کاربری</th>

                    </tr>
                </thead>
            </table>
           
            <div id="gridtoolbarWhiteList" style="padding:2px 5px;">
                تاریخ حمل:<input id="dpVoucherDateWhiteList"class="dpTextBox dpTextBox-Invalid" style="width:100px;background-color:antiquewhite;">
                <input tabindex="4" id="txtIranPlateNoWhiteList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                <span>ایران</span>
                <input tabindex="3" id="txtThreePlateNoWhiteList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">

                <select tabindex="2" id="drpTwoPlateNoWhiteList" class="easyui-combobox" data-options="width:'40px'">
                    <option value="-1" selected="selected"></option>
                    <option value="01">الف</option>
                    <option value="02">ب</option>
                    <option value="04">ت</option>
                    <option value="06">ج</option>
                    <option value="07">چ-ژ</option>
                    <option value="10">د</option>
                    <option value="15">س</option>
                    <option value="17">ص</option>
                    <option value="19">ط</option>
                    <option value="21">ع</option>
                    <option value="24">ق</option>
                    <option value="27">ل</option>
                    <option value="28">م</option>
                    <option value="29">ن</option>
                    <option value="30">و</option>
                    <option value="31">هـ</option>
                    <option value="32">ی</option>
                    <option value="33">D</option>
                    <option value="34">S</option>
                </select>
                <input tabindex="1" type="text" id="txtOnePlateNoWhiteList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">
                <a onclick="WhiteList_SearchOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو</a>
                <a onclick="WhiteListList_ClearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
               
                <a id="btnPrintWhiteList" onclick="printWhiteList()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ</a>
                <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>

            </div>
            </div>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
       
        var grdWhiteList = $('#grdWhiteList');


        function toExcel() {
            $('#grdWhiteList').datagrid('toExcel', 'dg.xls');
        }


        $(function () {

            grdWhiteList.initializeGrid({
                ////title: '',
                //filterBtnPosition: 'left',
                //remoteFilter: true,
                //method: 'get',
                //fit: true,
                //singleSelect: true,
                //collapsible: true,
                //fitColumns: true,
                //pagination: true,
                //pageSize: 20,
                //pageList: [5, 10, 20, 50, 100, 99999],
                url: '/CoreServices/API/WhiteList/GetList',
                /*rownumbers: true,*/
                sortName: 'WhiteListId',
                sortOrder: 'asc',
                /*isBindOnLoad: false,*/
                toolbar: '#gridtoolbarWhiteList'
                ,

                queryParams: {
                    
                    plateNo: '',
                    voucherDate: ''
                }

            });
     

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;



            grdWhiteList.datagrid('enableFilter', [
 
              {
                  field: 'MISPlaque',
                  type: 'text',
                  op: textOp,
              },
               {
                   field: 'DiscountPercent',
                   type: 'text',
                   op: numberBoxOP,
                },

                {
                    field: 'VoucherDate',
                    type: 'datebox',
                    op: dateboxOp,
                },
                    {
                        field: 'UsageName',
                        type: 'text',
                        op: textOp,
                    }

            ]);

        });

        function WhiteListList_ClearFilter() {

            $('#txtOnePlateNoWhiteList').textbox('clear');
            $('#txtThreePlateNoWhiteList').textbox('clear');
            $('#txtIranPlateNoWhiteList').textbox('clear');
            $('#drpTwoPlateNoWhiteList').combobox('reset');
            $('#dpVoucherDateWhiteList').val('');
           // $('#drpPrintWhiteList').combobox('clear');

            var opts = grdWhiteList.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['plateNo'] = '';
            opts.queryParams['voucherDate'] = '';
            grdWhiteList.datagrid('reload', opts.queryParams);

        }
        function WhiteList_SearchOnDB() {

            var opts = grdWhiteList.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNo(false,'txtOnePlateNoWhiteList', 'drpTwoPlateNoWhiteList', 'txtThreePlateNoWhiteList', 'txtIranPlateNoWhiteList');
            if (plaqueValue == 'error')
                return;
            
            

         
            var voucherDate = $('#dpVoucherDateWhiteList').dpGetEnValue();
            opts.queryParams['plateNo'] = plaqueValue;
            opts.queryParams['voucherDate'] = voucherDate;

            grdWhiteList.datagrid('reload', opts.queryParams);

        }
       


        function printWhiteList() {

            var plateNo = getPlateNo(false,'txtOnePlateNoWhiteList', 'drpTwoPlateNoWhiteList', 'txtThreePlateNoWhiteList', 'txtIranPlateNoWhiteList');
            var voucherDate = $('#dpVoucherDateWhiteList').dpGetEnValue();
            //if (plateNo == '') {
            //    $.messager.alert('اخطار', 'پلاک را وارد نمایید');
            //    return;
            //}
            var queryParam =
                {
                    plateNo: plateNo,
                    voucherDate: voucherDate
                };

            var opts = grdWhiteList.datagrid('options');
            //OrderBy
            queryParam.orderby = opts.finalOrder;
            if (opts.filterRulesString)
                queryParam.filter = opts.filterRulesString;
            var recursiveEncoded = $.param(queryParam);

            window.open('/Reports/Print/PrintWhiteList.html?' + recursiveEncoded);
        }
       
        $(document).ready(function () {
            restrictAccess();
        });
    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>