﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px">
        <div data-options="region:'center',title:'لیست تعداد باربرگ های صادر شده در روز'">
            <table id="grdProgramReportList">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'VoucherRequestDate', sortable:'true',width:300">تاریخ</th>
                        <th data-options="field:'Mobile', sortable:'true',width:290">موبایل</th>
                        <th data-options="field:'USSD', sortable:'true',width:290">USSD</th>
                        <th data-options="field:'Web', sortable:'true',width:290">WEB</th>
                    </tr>
                </thead>
            </table>
            <div id="gridtoolbarProgramReport" style="padding:2px 5px;">
                <div style="background-color:#f4f4f4;padding:2px 5px;">
                    از تاریخ:<input id="fromDate" class="dpTextBox dpTextBox-Invalid" style="width:100px;background-color:antiquewhite;">
                           <input hidden id="txtFromDateVal"/>
                    تا تاریخ:<input id="toDate" class="dpTextBox dpTextBox-Invalid" style="width:100px;background-color:antiquewhite;">
                           <input hidden id="txtToDateVal"/>
                    <a onclick="ProgramReport_SearchOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو</a>
                    <a id="btnPrintProgramReport" onclick="printProgramReport()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ</a>
                    <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
                </div>
            </div>
        </div>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
        $(function () {

            //$('#fromDate').datepicker();
            //$('#toDate').datepicker();

            $.ajax({
                url: '/CoreServices/API/Shared/GetDate',
                type: 'GET',
                contentType: 'application/json',
                data: { diffDay: 0 },
                success: function (data) {
                    $('#fromDate').dpGetEnValue();
                    $('#toDate').dpGetEnValue();
                },
                error: function (xhr, textStatus, errorThrown) {
                }
            });
        });

        function toExcel() {
            $('#grdProgramReportList').datagrid('toExcel', 'dg.xls');
        }

        var grdProgramReportList = $('#grdProgramReportList');

        grdProgramReportList.datagrid({
            //title: '',
            filterBtnPosition: 'left',
            remoteFilter: true,
            method: 'get',
            fit: true,
            singleSelect: true,
            collapsible: true,
            fitColumns: true,
            pagination: true,
            pageSize: 20,
            pageList: [5, 10, 20, 50, 100, 99999],
            url: '/CoreServices/API/Voucher/GetListProgramReport',
            rownumbers: true,
            singleSelect: false,
            sortName: 'VoucherRequestDate',
            sortOrder: 'desc',
            isBindOnLoad: false,
            toolbar: '#gridtoolbarProgramReport',
            queryParams: {
            }
        });
        function ProgramReport_SearchOnDB() {

            var opts = grdProgramReportList.datagrid('options');
            opts.isBindOnLoad = true;

            var fromDate = $('#fromDate').val();
            var toDate = $('#toDate').val();

            opts.queryParams['fromDate'] = fromDate;
            opts.queryParams['toDate'] = toDate;

            grdProgramReportList.datagrid('reload', opts.queryParams);

        }

        function printProgramReport() {

            var fromDate = $('#fromDate').val();
            var toDate = $('#toDate').val();

            var queryParam = {
                fromDate: fromDate,
                toDate: toDate
            };
            var opts = grdProgramReportList.datagrid('options');
            //OrderBy
            queryParam.orderby = opts.finalOrder;
            if (opts.filterRulesString)
                queryParam.filter = opts.filterRulesString;
            var recursiveEncoded = $.param(queryParam);

            window.open('/Reports/Print/PrintProgramReport.html?' + recursiveEncoded);
        }

        $(document).ready(function () {
            restrictAccess();
        });

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>