﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout">
        
            <table id="grdMain_Brief">
                <thead>
                    <tr>
                        <th data-options="field:'RequestedBy_OfficeUsername', sortable:'true', width:160">دفتر/نماینده</th>
                        <th data-options="field:'پروانه_بهره_برداری', sortable:'true', width:160">پروانه بهره برداری</th>
                        <th data-options="field:'پروانه_فعالیت', sortable:'true', width:160">پروانه فعالیت</th>
                        <th data-options="field:'پروانه_اشتغال', sortable:'true', width:160">پروانه اشتغال</th>
                        <th data-options="field:'مجوز_تردد', sortable:'true', width:160">مجوز تردد</th>
                        <th data-options="field:'باربرگ', sortable:'true', width:160">باربرگ</th>
                    </tr>
                </thead>
            </table>
            <div id="grdMainToolbar_Brief" style="padding: 2px 5px;">
                <div style="padding: 2px 5px;">
                    از تاریخ :<input id="fromDate_Brief"class="dpTextBox dpTextBox-Invalid" style="background-color: antiquewhite; width: 100px;">
                         <input hidden id="txtFromDate_BriefVal"/>
                    تا تاریخ :<input id="toDate_Brief" class="dpTextBox dpTextBox-Invalid" style="background-color: antiquewhite; width: 100px;">
                         <input hidden id="txtFromDate_BriefVal"/>
                    <a onclick="searchCarListOnDB_Brief()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                    <a onclick="CarList_clearFilter_Brief()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                    <a onclick="toExcel_Brief()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">خروجی اکسل</a>

                    <a id="btnprintList" onclick="$('#grdMain_Brief').datagrid('print','گزارش خلاصه فعالیت دفاتر بر اساس زیر سیستم');" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ</a>
                    <a href="#" class="easyui-linkbutton" onclick="$('#grdMain_Brief').datagrid('toExcel', 'dg.xls');" iconCls="icon-">گزارش اکسل</a>

                </div>

            </div>


        
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>




        var grdMain_Brief = $("#grdMain_Brief");


        $(document).ready(function () {
            grdMain_Brief.datagrid({
                title: 'گزارش خلاصه فعالیت دفاتر بر اساس زیر سیستم',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: false,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/DashReports/DashReportOfficeActivitysummaryDateToDate?footer=پروانه_بهره_برداری:sum,پروانه_فعالیت:sum,پروانه_اشتغال:sum,مجوز_تردد:sum,باربرگ:sum',
                rownumbers: true,
                sortName: 'RequestedBy_OfficeUsername',
                sortOrder: 'desc',
                toolbar: '#grdMainToolbar_Brief',
                height: $(window).height() - 160,
                showFooter: true,
                onLoadSuccess: function (data) {
                    var footerData = [{
                        "RequestedBy_OfficeUsername": 'مجموع',
                        "پروانه_بهره_برداری": data.footer.پروانه_بهره_برداری,
                        "پروانه_فعالیت": data.footer.پروانه_فعالیت,
                        "پروانه_اشتغال": data.footer.پروانه_اشتغال,
                        "مجوز_تردد": data.footer.مجوز_تردد,
                        "باربرگ": data.footer.باربرگ,
                    }];


                    grdMain_Brief.datagrid('reloadFooter', footerData);
                },
                queryParams: {
                    fromDate: '',
                    toDate: ''
                }
            });

            grdMain_Brief.datagrid('enableFilter', [
                {
                    field: 'RequestedBy_OfficeUsername',
                    type: 'text',
                    op: textOp,
                }

            ]);

        });




        function toExcel_Brief() {
            $('#grdMain_Brief').datagrid('toExcel_Brief', 'dg.xls');
        }









        function searchCarListOnDB_Brief() {

            var opts = grdMain_Brief.datagrid('options');
            opts.isBindOnLoad = true;


            opts.queryParams['fromDate'] = $("#fromDate_Brief").combobox('getValue');
            opts.queryParams['toDate'] = $("#toDate_Brief").combobox('getValue');
            grdMain_Brief.datagrid('reload', opts.queryParams);

        }



        function CarList_clearFilter_Brief() {
            $("#fromDate_Brief").val('')
            $("#toDate_Brief").val('')


            var opts = grdMain_Brief.datagrid('options');
            opts.isBindOnLoad = true;
            opts.queryParams['fromDate'] = null;
            opts.queryParams['toDate'] = null;
            grdMain_Brief.datagrid('reload', opts.queryParams);

        }


    </script>

    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>
