﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div class="main Container" id="announce">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark">لیست موتورسیکلت های ثبت شده</h1>
                </div>
                <!-- /.col -->
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">
            <div data-options="region:'center',title:'لیست ناوگان موتورسیکلت و پروانه های صادر شده'">
                <table id="grdLicensingMotorcycleList">
                    <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'MotorcycleLicensingNumber', sortable:'true', width:160">شماره پروانه</th>
                        <th data-options="field:'RequestByUser', sortable:'true', width:160">نام کاربری درخواست دهنده</th>
                        <th data-options="field:'Vin', sortable:'true', width:160">VIN</th>
                        <th data-options="field:'PlateNo', sortable:'true', width:160">شماره پلاک</th>
                        <th data-options="field:'Driver_NationalCode', sortable:'true', width:160">کدملی راننده</th>
                        <th data-options="field:'Driver_Phone', sortable:'true', width:160">شماره تماس راننده</th>
                        <th data-options="field:'System', sortable:'true', width:160">سیستم</th>
                        <th data-options="field:'Color', sortable:'true', width:160">رنگ</th>

                        <th data-options="field:'UsageName', sortable:'true', width:160">کاربرد</th>
                        <th data-options="field:'LicensingDate', sortable:'true', width:160">تاریخ صدور</th>
                        <th data-options="field:'LicensingStatus', sortable:'true', width:160,formatter:licensingStatus"> : وضعیت</th>

                        <!--  <th data-options="field:'ExpireData', sortable:'true', width:160">تاریخ انقضا</th>-->
                        <!--<th runat="server" id="th_Facilities" data-options="field:'_operate', sortable:'true', width:160,align:'center',formatter:formatOper">معرفی جهت وام</th>-->

                    </tr>
                    </thead>
                </table>
                <div id="gridtoolbarLicensingCarList" style="padding: 2px 5px;">
                    <div style="padding: 2px 5px;">
                        <a href="#" class="easyui-linkbutton" onclick="edit()" iconcls="icon-display">نمایش اطلاعات</a>
                        <!--<a href="#" class="easyui-linkbutton" onclick="addNew()" iconcls="icon-add">افزودن مورد جدید</a>-->
                        <input id="txtPlakNo" type="text" class="easyui-numberbox" data-options="label:'پلاک :',width:'220px'">
                        <a href="#" class="easyui-linkbutton" onclick="searchByPlak()" iconcls="icon-search">جست و جو</a>

                    </div>
                </div>
            </div>
        </div>


        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->

</div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>


        var currentSelectedRowId;
        var grdLicensingMotorcycleList = $('#grdLicensingMotorcycleList');
        var winCarEdit = $('#winCarEdit');
        var winLicensing = $('#winLicensing');
        var drpLicenseOwner = $('#drpLicenseOwner');

        function searchByPlak() {

            var opts = grdLicensingMotorcycleList.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = $("#txtPlakNo").textbox("getValue");


            opts.queryParams['plaqueValue'] = plaqueValue;
            // opts.queryParams['type'] = 2;
            grdLicensingMotorcycleList.datagrid('reload', opts.queryParams);

        }
        function edit() {

            var row = grdLicensingMotorcycleList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            window.open('/AdminBaraneh/Baraneh/motorcycleLicensingEdit.aspx?MotorcycleLicensingId=' + row['MotorcycleLicensingId']);

        }
        function addNew() {
            window.open('/AdminBaraneh/Baraneh/motorcycleLicensingEdit.aspx');

        }

        function licensingStatus(val) {
            return {
               1: 'در دست بررسی' ,
                  2:  'تایید کردن',
                  3:  'رد کردن',
                  4:  'ویرایش شده',
                5:  'حذف شده',

            }[val];
        }

        $(function () {

            winCarEdit.window({
                width: '1060',
                height: '500',

                modal: true,
                title: "فرم اطلاعات خودروها",
                closed: true
            });

            winLicensing.window({
                width: '1060',
                height: '500',

                modal: true,
                title: "فرم اطلاعات پروانه صادر شده",
                closed: true
            });
            grdLicensingMotorcycleList.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: true,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [15, 50, 100, 99999],
                url: '/DesktopModules/MotorcycleProxy/API/MotorcycleLicensing/GetAllMotorcycleLicensing',
                rownumbers: true,
                sortName: 'MotorcycleLicensingId',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarLicensingCarList',
                height: $(window).height() - 160,

                queryParams: {
                    plaqueValue: ''
                }


            });
            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];



            grdLicensingMotorcycleList.datagrid('enableFilter', [
                {
                    field: 'RequestByUser',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'Driver_NationalCode',
                    type: 'text',
                    op: numberBoxOP,
                },
                
            ]);


        });

        function print() {

            var row = grdLicensingMotorcycleList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            //openEditLicensingWindow('/Reports/Print/PrintLicensing.html?vehicleId=' + row['VehicleId']);
            window.open("/Print/PrintLicensing.html?vehicleId=" + row['VehicleId']);
        }
        function formatOper(val, row, index) {
            currentSelectedRowId = row.MotorcycleLicensingId;
            //
            if (row.GetFacilities) {
                return `<input type="checkbox" checked data-row="` + row + `" onchange="addToFacilitiesList(event)"/>`;

            }
            return `<input type="checkbox" data-row="` + row + `" onchange="addToFacilitiesList(event)"/>`;

        }
        function addToFacilitiesList(ev) {
            if (ev.target.checked) {
                $.messager.confirm('پیام سیستم', 'موتور سیکلت مورد نظر جهت دریافت تسهیلات معرفی شود ؟', function (r) {
                    if (r) {
                        $.ajax({

                            url: '/DesktopModules/MotorcycleProxy/API/MotorcycleLicensing/AddToFacilitiesList',
                            type: 'Get',
                            contentType: 'application/json',
                            data: { licensingId: currentSelectedRowId },
                            success: function (data) {
                                $.messager.alert(data.Title, data.Message);

                            },
                            error: function (xhr, textStatus, errorThrown) {
                                //
                                window.location.replace("/login.aspx");
                            }
                        });
                    }
                });

            } else {
                $.messager.confirm('پیام سیستم', 'حذف موتور سیکلت مورد نظر از دریافت تسهیلات ؟', function (r) {
                    if (r) {
                        $.ajax({

                            url: '/DesktopModules/MotorcycleProxy/API/MotorcycleLicensing/RemoveFromFacilitiesList',
                            type: 'Get',
                            contentType: 'application/json',
                            data: { licensingId: currentSelectedRowId },
                            success: function (data) {
                                $.messager.alert(data.Title, data.Message);

                            },
                            error: function (xhr, textStatus, errorThrown) {
                                //
                                window.location.replace("/login.aspx");
                            }
                        });
                    }
                });

            }
        }

        function showDataCarList(type) {

            var opts = grdLicensingMotorcycleList.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error')
                return;

            opts.queryParams['plaqueValue'] = plaqueValue;
            opts.queryParams['type'] = type;
            grdLicensingMotorcycleList.datagrid('reload', opts.queryParams);

        }
        function CarList_clearFilter() {

            $('#txtOnePlateNoCarList').textbox('clear');
            $('#txtThreePlateNoCarList').textbox('clear');
            $('#txtIranPlateNoCarList').textbox('clear');
            $('#drpTwoPlateNoCarList').combobox('reset');
            //$('#drpTwoPlateNo').combobox('unselect', value);

            var opts = grdLicensingMotorcycleList.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['plaqueValue'] = '';
            opts.queryParams['type'] = 2;
            grdLicensingMotorcycleList.datagrid('reload', opts.queryParams);

        }
        
        var licenseOwnerIdInSelectGrid = 0;


        $(document).ready(function () {
            restrictAccess();
        });



    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>