﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height: 500px; width: 100%">
    <div data-options="region:'center',title:'لیست موتور سیکلت های ارایه شده جهت نو سازی ناوگان'">

        <table id="grdMotorcycleFacilitiesRequestList">
            <thead>
            <tr>

                <th field="ck" checkbox="true"></th>
                <th data-options="field:'MotorcycleFacilitiesRequestId', sortable:'true', width:160" hidden="hidden"></th>
                <th data-options="field:'UserName', sortable:'true', width:160">نام کاربری</th>
                <th data-options="field:'Title', sortable:'true', width:160">عنوان</th>
                <th data-options="field:'Description', sortable:'true', width:160" hidden="hidden"></th>
                <th data-options="field:'CreateDate', sortable:'true', width:70">تاریخ درخواست</th>
                <th data-options="field:'ViewDate', sortable:'true', width:70">تاریخ دیده شدن</th>
                <th data-options="field:'AcceptedDate', sortable:'true', width:70">تاریخ تایید</th>
                <th data-options="field:'RejectedDate', sortable:'true', width:160">تاریخ رد شدن</th>
                <th data-options="field:'DeletedDate', sortable:'true', width:160">تاریخ حذف</th>
            </tr>
            </thead>
        </table>
        <div id="gridtoolbarMotorcycleFacilities" style="padding: 2px 5px;">
            <div style="padding: 2px 5px;">
                فیلتر عنوان :
                <select required class="col-md-6 easyui-combobox" id="drpFacilities" style="width: 150px;">
                </select>

                جست و جو :
                <input id="txtSearch" type="text" class="easyui-textbox"/>
                <a onclick="searchCarListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جست و جو </a>
                <a onclick="deleteFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-refresh'">حذف فیلتر </a>

                <a href="#" class="easyui-linkbutton" onclick="addDate('View')" iconCls="icon-display">مشاهده شد </a>
                <a href="#" class="easyui-linkbutton" onclick="addDate('Accepted')" iconCls="icon-ok">تایید</a>
                <a href="#" class="easyui-linkbutton" onclick="addDate('Rejected')" iconCls="icon-remove">رد </a>
                <a href="#" class="easyui-linkbutton" onclick="addDate('Delete')" iconCls="icon-cancel">حذف </a>
            </div>
        </div>
    </div>
</div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>

        var grdMotorcycleFacilitiesRequestList = $("#grdMotorcycleFacilitiesRequestList");

        const addDate = function (param) {


            var row = grdMotorcycleFacilitiesRequestList.datagrid('getSelected');
            if (!row) {
                $.messager.alert('پیغام', "لطفا ابتدا  رکورد مورد نظر را انتخاب کنید");
                return;
            }

            $.messager.progress({ title: 'لطفا صبر کنید...' });
            var urlSegment = 'Add' + param + 'Date';
            $.ajax({
                url: '/DesktopModules/MotorcycleProxy/API/MotorcycleFacilities/' + urlSegment,
                type: 'Post',
                contentType: 'application/json',
                data: JSON.stringify(row.MotorcycleFacilitiesRequestId),
                success: function (data) {
                    $.messager.progress('close');

                    if (data) {
                        if (data.IsSuccessful == true) {
                            grdMotorcycleFacilitiesRequestList.datagrid('reload');
                        }
                        $.messager.alert('پیغام', data.Message);
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                }
            });

        }
        const searchCarListOnDB = function () {

            var opts = grdMotorcycleFacilitiesRequestList.datagrid('options');
            opts.isBindOnLoad = true;
            var query = $('#txtSearch').textbox('getValue');
            opts.queryParams['query'] = query
            opts.queryParams['facilitiesId'] = $('#drpFacilities').combobox("getValue");
            grdMotorcycleFacilitiesRequestList.datagrid('reload', opts.queryParams);
        }

        const deleteFilter = function () {
            var opts = grdMotorcycleFacilitiesRequestList.datagrid('options');
            opts.isBindOnLoad = true;
            var query = $('#txtSearch').textbox('getValue');
            opts.queryParams['query'] =''
            opts.queryParams['facilitiesId'] = '';
            grdMotorcycleFacilitiesRequestList.datagrid('reload', opts.queryParams);
        }



        $(document).ready(() => {
            grdMotorcycleFacilitiesRequestList.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: true,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [15, 50, 100, 99999],
                url: '/DesktopModules/MotorcycleProxy/API/MotorcycleFacilities/GetAllRequests',
                rownumbers: true,
                sortName: 'CreateDate',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarMotorcycleFacilities',
                height: $(window).height() - 160,
                queryParams: {
                    query: '',
                    facilitiesId:''
                },
                onSelect: function (e) {
                    //var selected = grdMotorcycleFacilities.datagrid("getSelected");
                    //MotorcycleFacilitiesId = selected.MotorcycleFacilitiesId;
                    //$("#IsActive").prop("checked", selected.IsActive);
                    //$("#txtDescription").textbox("setValue", selected.Description);
                    //$("#txtTitle").textbox("setValue", selected.Title);
                }
            });


            $('#drpFacilities').combobox({
                method: 'get',
                url: '/DesktopModules/MotorcycleProxy/API/MotorcycleFacilities/GetAll?query&isActive=true',
                valueField: 'MotorcycleFacilitiesId',
                textField: 'Title',
                multiple: false,
                onChange: function (data) {


                    searchCarListOnDB();

            
                }
            });
        });


    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>