﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    @keyframes zoomimage {
            from {
                position: absolute;
                transform: scale(2);
            }

            to {
                position: absolute;
                transform: scale(3);
                z-index: 9999999;
            }
        }

        .img-prev { cursor: pointer; }

        .img-prev:hover {
            animation: zoomimage 0.5s both;
            cursor: zoom-in;
        }

    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height: 500px; width: 100%">
    <div data-options="region:'center',title:'لیست درخواستها'">
        <table id="grdMotorcycleFacilities">
            <thead>
            <tr>
                <th field="ck" checkbox="true"></th>
                <th data-options="field:'MotorcycleFacilitiesId', sortable:'true', width:160" hidden="hidden"></th>
                <th data-options="field:'MotorcycleName', sortable:'true', width:160">نام موتور سیکلت</th>
                <th data-options="field:'CompanyName', sortable:'true', width:70">نام شرکت تولید کننده</th>
                <th data-options="field:'MotorcycleSystem', sortable:'true', width:70">سیستم</th>
                <th data-options="field:'MotorcycleType', sortable:'true', width:70">نوع</th>
                <th data-options="field:'Price', sortable:'true', width:160">قیمت (تومان)</th>
                <th data-options="field:'MotorcycleImage', sortable:'true', width:160,formatter:loadImage">تصویر</th>
            </tr>
            </thead>
        </table>

        <div id="gridtoolbarMotorcycleFacilities" style="padding: 2px 5px;">
            <div style="padding: 2px 5px;">

                <a href="#" class="easyui-linkbutton" onclick="edit()" iconCls="icon-display">ویرایش اطلاعات</a>
                <a href="#" class="easyui-linkbutton" onclick="addNew()" iconCls="icon-add">افزودن مورد جدید</a>
                <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
            </div>
        </div>
    </div>
</div>
<div id="dlgMotorcycleFacilitiesList" class="easyui-dialog" style="height: 220px; padding: 10px 20px; width: 420px;"
     closed="true">

</div>


<div id="winMotorcycleEdit" title="Basic Window"></div>
<div id="winMotorcycleFacilities" title="Basic Window">
</div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
        var grdMotorcycleFacilities = $('#grdMotorcycleFacilities');
        //var winMotorcycleEdit = $('#winMotorcycleEdit');
        //var winMotorcycleFacilities = $('#winMotorcycleFacilities');
        function toExcel() {
            $('#grdMotorcycleFacilities').datagrid('toExcel', 'dg.xls');
        }

        function loadImage(val , row, index)
        {
            //
            return "<img class='img-prev' width='100' height='100' src='" + row.MotorcycleImage.substr(0, row.MotorcycleImage.length) + "'/>";
        }
        function edit() {

            var row = grdMotorcycleFacilities.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            window.open('/AdminBaraneh/Baraneh/MotorcycleFacilitiesEdit.aspx?id=' + row['MotorcycleFacilitiesId']);

        }
        function addNew() {

            

            window.open('/AdminBaraneh/Baraneh/MotorcycleFacilitiesEdit.aspx');

        }
        $(function () {



            grdMotorcycleFacilities.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: true,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [15, 50, 100, 99999],
                url: '/DesktopModules/MotorcycleProxy/API/MotorcycleFacilities/GetAll',
                rownumbers: true,
                sortName: 'MotorcycleName',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarMotorcycleFacilities',
                height: $(window).height() - 160
            });
        });
        $(document).ready(function () {
            restrictAccess();
        });

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>