﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px">
        <div data-options="region:'center',title:'مدیریت قالب پیامها'">

            <table id="grdMessageTemplates">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'Title', sortable:'true', width:60">موضوع پیام</th>
                        <th data-options="field:'FullMessage', sortable:'true', width:110">متن پیام</th>
                    </tr>
                </thead>
            </table>
            <div id="grdToolbar" style="padding:2px 5px;">
                <a id="LicenseOwnerEdit_btnsaveMessage" href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-message" onclick="newMessageDialog()">جدید</a>
                <a id="LicenseOwnerEdit_btnEditMessge" href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-message" onclick="editMessageDialog()">ویرایش</a>
                <a href="javascript:void(0)" class="easyui-linkbutton" onclick="deleteMessageTemplate()" iconcls="icon-cancel">حذف</a>

            </div>



        </div>
    </div>

    <div id="dlgMessage" class="easyui-dialog" style="width:620px;height:270px;padding:10px 20px"
         closed="true">
        <form id="frmEdit" method="post" novalidate>

            <table>
                <tr>
                    <td style="width:15%; text-align:left;">
                        <label> زیر سیستم:</label>
                    </td>

                    <td>
                        <input id="drpDlgSubSystems" class="easyui-combobox" tipPosition="left" style="width:520px;height:30px ">
                    </td>
                </tr>
                <tr>
                    <td style="width: 15%; text-align: left;">
                        <label> موضوع پیام:</label>
                    </td>

                    <td>
                        <input id="txtMessageTitle" class="easyui-textbox" tipPosition="left" style="width: 520px; height: 30px" data-options="multiline:true">
                    </td>
                </tr>

                <tr>
                    <td style="width: 15%; text-align: left;">
                        <label> متن پیام:</label>
                    </td>

                    <td>
                        <input id="txtMessageBody" class="easyui-textbox" tipPosition="left" style="width: 520px; height: 100px" data-options="multiline:true">
                    </td>
                </tr>

            </table>
        </form>
        <a href="javascript:void(0)" class="easyui-linkbutton c6" style="width:90px" iconcls="icon-ok" onclick="saveMessage()">ذخیره</a>
        <a href="javascript:void(0)" class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript:$('#dlgMessage').dialog('close')" style="width:90px">لغو</a>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>


        var globalTemplateRow = null;

        function newMessageDialog() {
            $('#txtMessageBody').textbox('clear');
            $('#dlgMessage').dialog('open').dialog('center').dialog('setTitle', 'ذخیره قالب');
        }




        function editMessageDialog() {
            $('#txtMessageBody').textbox('clear');
            var row = $('#grdMessageTemplates').datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                $('#dlg').dialog('close');
                return;
            }
            globalTemplateRow = row;

            $('#txtMessageTitle').textbox('setValue', globalTemplateRow.Title);
            $('#txtMessageBody').textbox('setValue', globalTemplateRow.FullMessage);
            $('#drpDlgSubSystems').combobox('setValue', globalTemplateRow.SubSystemId);
            $('#dlgMessage').dialog('open').dialog('center').dialog('setTitle', 'ذخیره قالب');

        }

        $('#drpDlgSubSystems').combobox({
            method: 'get',
            url: '/CoreServices/API/UsersAccess/SubSystems?withAll=false',
            valueField: 'SubSystemId',
            textField: 'Title',
            multiple: false,
        });


        function saveMessage() {

            var txtMessageTitle = $('#txtMessageTitle').textbox('getValue');
            var txtmessageBody = $('#txtMessageBody').textbox('getValue');
            var subSystemId = $('#drpDlgSubSystems').textbox('getValue');

            var templateId = 0;

            if (globalTemplateRow != null) {
                templateId = globalTemplateRow.TemplateId;
            }


            data = {

                TemplateId: templateId,
                Title: txtMessageTitle,
                FullMessage: txtmessageBody,
                SubSystemId: subSystemId

            }

            $.ajax({
                url: '/CoreServices/API/MessageTemplates/InsertUpdate',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(data),
                success: function (data) {

                    if (data.IsSuccessful == true) {

                        //sendAttachments(data.ReturnValue); //فایل
                        //$.messager.progress('close');
                        //$("#LicenseOwnerEdit_btnConfirm").linkbutton('disable');
                        //$("#LicenseOwnerEdit_btnDeny").linkbutton('enable');
                        $.messager.show({
                            title: 'پیغام سیستم',
                            msg: data.Message,
                            timeout: 1000,
                            showType: 'slide',
                            style: {
                                right: '',
                                bottom: ''
                            }
                        });
                        globalTemplateRow = null;
                        var opts = grdMessageTemplates.datagrid('options');
                        opts.isBindOnLoad = true;
                        opts.queryParams['subSystemId'] = 0;
                        //opts.queryParams['type'] = 0;
                        grdMessageTemplates.datagrid('reload', opts.queryParams);

                    }
                    else {
                        $.messager.progress('close');
                        $.messager.alert('Warning', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });
        }



        function deleteMessageTemplate() {


            var row = grdMessageTemplates.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            var selectlicense = row.TemplateId;




            $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                if (r) {

                    //انتخاب اول
                    //$.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                    $.ajax({
                        url: '/CoreServices/API/MessageTemplates/DeleteByTemplateId',
                        type: 'GET',
                        contentType: 'application/json',
                        data: {
                            templateId: selectlicense,

                        },
                        async: false,
                        success: function (data) {

                            if (data.IsSuccessful == true) {
                                var opts = grdMessageTemplates.datagrid('options');
                                opts.isBindOnLoad = true;
                                opts.queryParams['subSystemId'] = 0;
                                //opts.queryParams['type'] = 0;
                                grdMessageTemplates.datagrid('reload', opts.queryParams);

                                //$.messager.alert('پیام سیستمی', data.Message, "info");

                                //showlist();


                            }
                            else {
                                $.messager.alert('Warning', data.Message);
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        }
                    });

                    $.messager.progress('close');
                }
            });

        }


        

        var grdMessageTemplates = $('#grdMessageTemplates');


        $(function () {

            grdMessageTemplates.initializeGrid({
                //filterBtnPosition: 'left',
                //remoteFilter: true,
                //method: 'get',
                //fit: true,
                //singleSelect: true,
                //collapsible: true,
                //fitColumns: true,
                //pagination: true,
                //rownumbers: true,
                //pageSize: 15,
                //pageList: [15, 50, 100, 99999],
                //rownumbers: true,
                url: '/CoreServices/API/MessageTemplates/GetTitleList',
                sortName: 'TemplateId',
                sortOrder: 'desc',
                toolbar: '#grdToolbar',
                onDblClickRow: function (index, row) {

                    editMessageDialog();
                },
                queryParams: {
                    subSystemId: 0
                }

            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;



            grdMessageTemplates.datagrid('enableFilter', [
                {
                    field: 'Title',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'FullMessage',
                    type: 'text',
                    op: textOp,
                }
            ]);

        });


    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>