﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div class="main containers" id="frmTransferPlate">

    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark">لیست درخواست های خروج پلاک عمومی</h1>
                </div>
                <!-- /.col -->
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>

    <section class="content">
        <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">
            <div data-options="region:'center',title:'لیست درخواست های خروج پلاک عمومی'">
                <table id="grdMain">
                    <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'ExitPublicPlateId'" hidden="hidden"></th>
                        <th data-options="field:'State'" hidden="hidden"></th>
                        <th data-options="field:'UserName', sortable:'true', width:160">نام کاربر درخواست دهنده</th>
                        <th data-options="field:'PlateNo', sortable:'true', width:160," hidden="hidden"> </th>
                        <th data-options="field:'VIN', sortable:'true', width:160">VIN</th>
                        <th data-options="field:'PlateStr', sortable:'true', width:160">شماره پلاک</th>
                        <th data-options="field:'CreateDate', sortable:'true', width:160">تاریخ ثبت</th>
                        <th data-options="field:'StrState', sortable:'true', width:160">وضعیت</th>
                    </tr>
                    </thead>
                </table>
                <div id="grdMainToolbar" style="padding: 2px 5px;">
                    <div style="padding: 2px 5px;">
                        <input tabindex="4" id="txtIranPlateNoCarList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                        <span>ایران</span>
                        <input tabindex="3" id="txtThreePlateNoCarList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                        <select tabindex="2" id="drpTwoPlateNoCarList" class="easyui-combobox" data-options="width:'40px'">
                            <option value="-1" selected="selected"></option>

                            <option value="21">ع</option>

                        </select>
                        <input tabindex="1" type="text" id="txtOnePlateNoCarList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">
                        <a onclick="DeleteRequest()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-cancel'">حذف درخواست</a>
                        <a onclick="Display()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-display'">نمایش</a>
                        <a onclick="searchCarListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                        <a onclick="CarList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                        <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
                    </div>
                </div>
            </div>
        </div>
    </section>


</div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
        var grdMain = $("#grdMain");

        $(document).ready(() => {

            initComponent();
        });


        function toExcel() {
            $('#grdMain').datagrid('toExcel', 'dg.xls');
        }

        var initComponent = () => {

            grdMain.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: false,
                method: 'get',
                fit: true,
                singleSelect: false,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/ExitPublicPlate/GetAll',
                rownumbers: true,
                sortName: 'ExitPublicPlateId',
                sortOrder: 'desc',
                toolbar: '#grdMainToolbar',
                height: $(window).height() - 160,

                queryParams: {
                    plaqueValue: ''
                }
            });

        }



        function searchCarListOnDB() {

            var opts = grdMain.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error')
                return;

            opts.queryParams['plaqueValue'] = plaqueValue;
            grdMain.datagrid('reload', opts.queryParams);

        }

        


        function CarList_clearFilter() {

            $('#txtOnePlateNoCarList').textbox('clear');
            $('#txtThreePlateNoCarList').textbox('clear');
            $('#txtIranPlateNoCarList').textbox('clear');
            $('#drpTwoPlateNoCarList').combobox('reset');
            //$('#drpTwoPlateNo').combobox('unselect', value);

            var opts = grdLicensingCarList.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['plaqueValue'] = '';
            opts.queryParams['type'] = 2;
            grdLicensingCarList.datagrid('reload', opts.queryParams);

        }

        var DeleteRequest = () => {
            
            var row = grdMain.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            var ExitPublicPlateId = row.ExitPublicPlateId;
            $.messager.progress({ title: 'لطفا صبر کنید...' });



            $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                if (r) {
                    
                    //انتخاب اول
                    //$.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                    $.ajax({
                        url: '/CoreServices/API/ExitPublicPlate/Delete',
                        type: 'Post',
                        contentType: 'application/json',
                        data: JSON.stringify(ExitPublicPlateId),
                        async: false,
                        success: function (data) {
                            $.messager.progress('close');

                            if (data.IsSuccessful == true) {
                                searchCarListOnDB();

                            }
                            else {
                                $.messager.alert('Warning', data.Message);
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            $.messager.progress('close');
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        }
                    });

                }
            });

        }
        var Display = () => {
            var row = grdMain.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            var ExitPublicPlateWin = window.open("/AdminBaraneh/Baraneh/ExitPublicPlate.aspx");

            ExitPublicPlateWin.window.ExitPublicPlate = {
                ExitPublicPlateId: row.ExitPublicPlateId,
                VIN: row.VIN,
                PlateNo: row.PlateNo,
                CreateDate: row.CreateDate,
                State: row.State
            }
        }


    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>